/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;

public class InvalidConfigurationTests {
    private InMemoryXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test(expected=XmlBeanDefinitionStoreException.class)
    public void passwordEncoderCannotAppearAtTopLevel() {
        this.setContext("<password-encoder hash='md5'/>");
    }

    @Test(expected=XmlBeanDefinitionStoreException.class)
    public void authenticationProviderCannotAppearAtTopLevel() {
        this.setContext("<authentication-provider ref='blah'/>");
    }

    @Test
    public void missingAuthenticationManagerGivesSensibleErrorMessage() {
        try {
            this.setContext("<http auto-config='true' />");
        }
        catch (BeanCreationException e) {
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof NoSuchBeanDefinitionException));
            NoSuchBeanDefinitionException nsbe = (NoSuchBeanDefinitionException)e.getCause().getCause();
            Assert.assertEquals((Object)"org.springframework.security.authenticationManager", (Object)nsbe.getBeanName());
            Assert.assertTrue((boolean)nsbe.getMessage().endsWith("Did you forget to add an <authentication-manager> element to your configuration (with child <authentication-provider> elements) ?"));
        }
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

