/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.util.FieldUtils;

public class AuthenticationManagerBeanDefinitionParserTests {
    private static final String CONTEXT = "<authentication-manager>    <authentication-provider>        <user-service>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />        </user-service>    </authentication-provider></authentication-manager>";
    private AbstractXmlApplicationContext appContext;

    @Test
    public void providersAreRegisteredAsTopLevelBeans() throws Exception {
        this.setContext(CONTEXT, "3.0");
        Assert.assertEquals((long)1L, (long)this.appContext.getBeansOfType(AuthenticationProvider.class).size());
    }

    @Test
    public void eventsArePublishedByDefault() throws Exception {
        this.setContext(CONTEXT, "3.0");
        AuthListener listener = new AuthListener();
        this.appContext.addApplicationListener((ApplicationListener)listener);
        ProviderManager pm = (ProviderManager)this.appContext.getBeansOfType(ProviderManager.class).values().toArray()[0];
        Object eventPublisher = FieldUtils.getFieldValue((Object)pm, (String)"eventPublisher");
        Assert.assertNotNull((Object)eventPublisher);
        Assert.assertTrue((boolean)(eventPublisher instanceof DefaultAuthenticationEventPublisher));
        pm.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword"));
        Assert.assertEquals((long)1L, (long)listener.events.size());
    }

    @Test
    public void credentialsAreNotClearedByDefault() throws Exception {
        this.setContext(CONTEXT, "3.0");
        ProviderManager pm = (ProviderManager)this.appContext.getBeansOfType(ProviderManager.class).values().toArray()[0];
        Assert.assertFalse((boolean)pm.isEraseCredentialsAfterAuthentication());
    }

    @Test
    public void clearCredentialsPropertyIsRespected() throws Exception {
        this.setContext("<authentication-manager erase-credentials='true'/>", "3.0.3");
        ProviderManager pm = (ProviderManager)this.appContext.getBeansOfType(ProviderManager.class).values().toArray()[0];
        Assert.assertTrue((boolean)pm.isEraseCredentialsAfterAuthentication());
    }

    private void setContext(String context, String version) {
        this.appContext = new InMemoryXmlApplicationContext(context, version, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AuthListener
    implements ApplicationListener<AbstractAuthenticationEvent> {
        List<AbstractAuthenticationEvent> events = new ArrayList<AbstractAuthenticationEvent>();

        private AuthListener() {
        }

        public void onApplicationEvent(AbstractAuthenticationEvent event) {
            this.events.add(event);
        }
    }
}

