/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.ReflectionSaltSource;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.util.FieldUtils;

public class AuthenticationProviderBeanDefinitionParserTests {
    private AbstractXmlApplicationContext appContext;
    private UsernamePasswordAuthenticationToken bob = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test
    public void worksWithEmbeddedUserService() {
        this.setContext(" <authentication-provider>        <user-service>            <user name='bob' password='bobspassword' authorities='ROLE_A' />        </user-service>    </authentication-provider>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    @Test
    public void externalUserServiceRefWorks() throws Exception {
        this.appContext = new InMemoryXmlApplicationContext("    <authentication-manager>        <authentication-provider user-service-ref='myUserService' />    </authentication-manager>    <user-service id='myUserService'>       <user name='bob' password='bobspassword' authorities='ROLE_A' />    </user-service>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    @Test
    public void providerWithMd5PasswordEncoderWorks() throws Exception {
        this.setContext(" <authentication-provider>        <password-encoder hash='md5'/>        <user-service>            <user name='bob' password='12b141f35d58b8b3a46eea65e6ac179e' authorities='ROLE_A' />        </user-service>    </authentication-provider>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    @Test
    public void providerWithShaPasswordEncoderWorks() throws Exception {
        this.setContext(" <authentication-provider>        <password-encoder hash='{sha}'/>        <user-service>            <user name='bob' password='{SSHA}PpuEwfdj7M1rs0C2W4ssSM2XEN/Y6S5U' authorities='ROLE_A' />        </user-service>    </authentication-provider>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    @Test
    public void providerWithSha256PasswordEncoderIsSupported() throws Exception {
        this.setContext(" <authentication-provider>        <password-encoder hash='sha-256'/>        <user-service>            <user name='bob' password='notused' authorities='ROLE_A' />        </user-service>    </authentication-provider>");
        ShaPasswordEncoder encoder = (ShaPasswordEncoder)FieldUtils.getFieldValue((Object)this.getProvider(), (String)"passwordEncoder");
        Assert.assertEquals((Object)"SHA-256", (Object)encoder.getAlgorithm());
    }

    @Test
    public void passwordIsBase64EncodedWhenBase64IsEnabled() throws Exception {
        this.setContext(" <authentication-provider>        <password-encoder hash='md5' base64='true'/>        <user-service>            <user name='bob' password='ErFB811YuLOkbupl5qwXng==' authorities='ROLE_A' />        </user-service>    </authentication-provider>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    @Test
    public void externalUserServicePasswordEncoderAndSaltSourceWork() throws Exception {
        this.appContext = new InMemoryXmlApplicationContext("    <authentication-manager>      <authentication-provider user-service-ref='customUserService'>        <password-encoder ref='customPasswordEncoder'>            <salt-source ref='saltSource'/>        </password-encoder>      </authentication-provider>    </authentication-manager>    <b:bean id='customPasswordEncoder' class='org.springframework.security.authentication.encoding.Md5PasswordEncoder'/>    <b:bean id='saltSource'            class='" + ReflectionSaltSource.class.getName() + "'>" + "         <b:property name='userPropertyToUse' value='username'/>" + "    </b:bean>" + "    <b:bean id='customUserService' " + "           class='org.springframework.security.core.userdetails.memory.InMemoryDaoImpl'>" + "        <b:property name='userMap' value='bob=f117f0862384e9497ff4f470e3522606,ROLE_A'/>" + "    </b:bean>");
        this.getProvider().authenticate((Authentication)this.bob);
    }

    private AuthenticationProvider getProvider() {
        List providers = ((ProviderManager)this.appContext.getBean("org.springframework.security.authenticationManager")).getProviders();
        return (AuthenticationProvider)providers.get(0);
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext("<authentication-manager>" + context + "</authentication-manager>");
    }
}

