/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.authentication.CachingUserDetailsService;
import org.springframework.security.config.authentication.JdbcUserServiceBeanDefinitionParser;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.util.FieldUtils;
import org.w3c.dom.Element;

public class JdbcUserServiceBeanDefinitionParserTests {
    private static String USER_CACHE_XML = "<b:bean id='userCache' class='org.springframework.security.authentication.dao.MockUserCache'/>";
    private static String DATA_SOURCE = "    <b:bean id='populator' class='org.springframework.security.config.DataSourcePopulator'>        <b:property name='dataSource' ref='dataSource'/>    </b:bean>    <b:bean id='dataSource' class='org.springframework.security.TestDataSource'>        <b:constructor-arg value='jdbcnamespaces'/>    </b:bean>";
    private InMemoryXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test
    public void beanNameIsCorrect() throws Exception {
        Assert.assertEquals((Object)JdbcUserDetailsManager.class.getName(), (Object)new JdbcUserServiceBeanDefinitionParser().getBeanClassName((Element)Mockito.mock(Element.class)));
    }

    @Test
    public void validUsernameIsFound() {
        this.setContext("<jdbc-user-service data-source-ref='dataSource'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("org.springframework.security.userDetailsService");
        Assert.assertNotNull((Object)mgr.loadUserByUsername("rod"));
    }

    @Test
    public void beanIdIsParsedCorrectly() {
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource'/>" + DATA_SOURCE);
        Assert.assertTrue((boolean)(this.appContext.getBean("myUserService") instanceof JdbcUserDetailsManager));
    }

    @Test
    public void usernameAndAuthorityQueriesAreParsedCorrectly() throws Exception {
        String userQuery = "select username, password, true from users where username = ?";
        String authoritiesQuery = "select username, authority from authorities where username = ? and 1 = 1";
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource' users-by-username-query='" + userQuery + "' " + "authorities-by-username-query='" + authoritiesQuery + "'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)userQuery, (Object)FieldUtils.getFieldValue((Object)mgr, (String)"usersByUsernameQuery"));
        Assert.assertEquals((Object)authoritiesQuery, (Object)FieldUtils.getFieldValue((Object)mgr, (String)"authoritiesByUsernameQuery"));
        Assert.assertTrue((mgr.loadUserByUsername("rod") != null ? 1 : 0) != 0);
    }

    @Test
    public void groupQueryIsParsedCorrectly() throws Exception {
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource' group-authorities-by-username-query='blah blah'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)"blah blah", (Object)FieldUtils.getFieldValue((Object)mgr, (String)"groupAuthoritiesByUsernameQuery"));
        Assert.assertTrue((boolean)((Boolean)FieldUtils.getFieldValue((Object)mgr, (String)"enableGroups")));
    }

    @Test
    public void cacheRefIsparsedCorrectly() {
        this.setContext("<jdbc-user-service id='myUserService' cache-ref='userCache' data-source-ref='dataSource'/>" + DATA_SOURCE + USER_CACHE_XML);
        CachingUserDetailsService cachingUserService = (CachingUserDetailsService)this.appContext.getBean("myUserService.caching");
        Assert.assertSame((Object)cachingUserService.getUserCache(), (Object)this.appContext.getBean("userCache"));
        Assert.assertNotNull((Object)cachingUserService.loadUserByUsername("rod"));
        Assert.assertNotNull((Object)cachingUserService.loadUserByUsername("rod"));
    }

    @Test
    public void isSupportedByAuthenticationProviderElement() {
        this.setContext("<authentication-manager>  <authentication-provider>    <jdbc-user-service data-source-ref='dataSource'/>  </authentication-provider></authentication-manager>" + DATA_SOURCE);
        AuthenticationManager mgr = (AuthenticationManager)this.appContext.getBean("org.springframework.security.authenticationManager");
        mgr.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala"));
    }

    @Test
    public void cacheIsInjectedIntoAuthenticationProvider() {
        this.setContext("<authentication-manager>  <authentication-provider>    <jdbc-user-service cache-ref='userCache' data-source-ref='dataSource'/>  </authentication-provider></authentication-manager>" + DATA_SOURCE + USER_CACHE_XML);
        ProviderManager mgr = (ProviderManager)this.appContext.getBean("org.springframework.security.authenticationManager");
        DaoAuthenticationProvider provider = (DaoAuthenticationProvider)mgr.getProviders().get(0);
        Assert.assertSame((Object)provider.getUserCache(), (Object)this.appContext.getBean("userCache"));
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala"));
        Assert.assertNotNull((String)"Cache should contain user after authentication", (Object)provider.getUserCache().getUserFromCache("rod"));
    }

    @Test
    public void rolePrefixIsUsedWhenSet() {
        this.setContext("<jdbc-user-service id='myUserService' role-prefix='PREFIX_' data-source-ref='dataSource'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        UserDetails rod = mgr.loadUserByUsername("rod");
        Assert.assertTrue((boolean)AuthorityUtils.authorityListToSet((Collection)rod.getAuthorities()).contains("PREFIX_ROLE_SUPERVISOR"));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

