/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class UserServiceBeanDefinitionParserTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test
    public void userServiceWithValidPropertiesFileWorksSuccessfully() {
        this.setContext("<user-service id='service' properties='classpath:org/springframework/security/config/users.properties'/>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("bob");
        userService.loadUserByUsername("joe");
    }

    @Test
    public void userServiceWithEmbeddedUsersWorksSuccessfully() {
        this.setContext("<user-service id='service'>    <user name='joe' password='joespassword' authorities='ROLE_A'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("joe");
    }

    @Test
    public void namePasswordAndAuthoritiesSupportPlaceholders() {
        System.setProperty("principal.name", "joe");
        System.setProperty("principal.pass", "joespassword");
        System.setProperty("principal.authorities", "ROLE_A,ROLE_B");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><user-service id='service'>    <user name='${principal.name}' password='${principal.pass}' authorities='${principal.authorities}'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        UserDetails joe = userService.loadUserByUsername("joe");
        Assert.assertEquals((Object)"joespassword", (Object)joe.getPassword());
        Assert.assertEquals((long)2L, (long)joe.getAuthorities().size());
    }

    @Test
    public void embeddedUsersWithNoPasswordIsGivenGeneratedValue() {
        this.setContext("<user-service id='service'>    <user name='joe' authorities='ROLE_A'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        UserDetails joe = userService.loadUserByUsername("joe");
        Assert.assertTrue((joe.getPassword().length() > 0 ? 1 : 0) != 0);
        Long.parseLong(joe.getPassword());
    }

    @Test
    public void disabledAndEmbeddedFlagsAreSupported() {
        this.setContext("<user-service id='service'>    <user name='joe' password='joespassword' authorities='ROLE_A' locked='true'/>    <user name='Bob' password='bobspassword' authorities='ROLE_A' disabled='true'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        UserDetails joe = userService.loadUserByUsername("joe");
        Assert.assertFalse((boolean)joe.isAccountNonLocked());
        UserDetails bob = userService.loadUserByUsername("bOb");
        Assert.assertFalse((boolean)bob.isEnabled());
    }

    @Test(expected=FatalBeanException.class)
    public void userWithBothPropertiesAndEmbeddedUsersThrowsException() {
        this.setContext("<user-service id='service' properties='doesntmatter.props'>    <user name='joe' password='joespassword' authorities='ROLE_A'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("joe");
    }

    @Test(expected=FatalBeanException.class)
    public void multipleTopLevelUseWithoutIdThrowsException() {
        this.setContext("<user-service properties='classpath:org/springframework/security/config/users.properties'/><user-service properties='classpath:org/springframework/security/config/users.properties'/>");
    }

    @Test(expected=FatalBeanException.class)
    public void userServiceWithMissingPropertiesFileThrowsException() {
        this.setContext("<user-service id='service' properties='classpath:doesntexist.properties'/>");
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

