/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;

public class FilterSecurityMetadataSourceBeanDefinitionParserTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    @Test
    public void parsingMinimalConfigurationIsSuccessful() {
        this.setContext("<filter-security-metadata-source id='fids'>   <intercept-url pattern='/**' access='ROLE_A'/></filter-security-metadata-source>");
        DefaultFilterInvocationSecurityMetadataSource fids = (DefaultFilterInvocationSecurityMetadataSource)this.appContext.getBean("fids");
        Collection cad = fids.getAttributes((Object)this.createFilterInvocation("/anything", "GET"));
        Assert.assertNotNull((Object)cad);
        Assert.assertTrue((boolean)cad.contains(new SecurityConfig("ROLE_A")));
    }

    @Test
    public void expressionsAreSupported() {
        this.setContext("<filter-security-metadata-source id='fids' use-expressions='true'>   <intercept-url pattern='/**' access=\"hasRole('ROLE_A')\" /></filter-security-metadata-source>");
        ExpressionBasedFilterInvocationSecurityMetadataSource fids = (ExpressionBasedFilterInvocationSecurityMetadataSource)this.appContext.getBean("fids");
        ConfigAttribute[] cad = fids.getAttributes((Object)this.createFilterInvocation("/anything", "GET")).toArray(new ConfigAttribute[0]);
        Assert.assertEquals((long)1L, (long)cad.length);
        Assert.assertEquals((Object)"hasRole('ROLE_A')", (Object)cad[0].toString());
    }

    @Test
    public void interceptUrlsSupportPropertyPlaceholders() {
        System.setProperty("secure.url", "/secure");
        System.setProperty("secure.role", "ROLE_A");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><filter-security-metadata-source id='fids'>   <intercept-url pattern='${secure.url}' access='${secure.role}'/></filter-security-metadata-source>");
        DefaultFilterInvocationSecurityMetadataSource fids = (DefaultFilterInvocationSecurityMetadataSource)this.appContext.getBean("fids");
        Collection cad = fids.getAttributes((Object)this.createFilterInvocation("/secure", "GET"));
        Assert.assertNotNull((Object)cad);
        Assert.assertEquals((long)1L, (long)cad.size());
        Assert.assertTrue((boolean)cad.contains(new SecurityConfig("ROLE_A")));
    }

    @Test
    public void parsingWithinFilterSecurityInterceptorIsSuccessful() {
        this.setContext("<http auto-config='true'/><b:bean id='fsi' class='org.springframework.security.web.access.intercept.FilterSecurityInterceptor' autowire='byType'>   <b:property name='securityMetadataSource'>       <filter-security-metadata-source>           <intercept-url pattern='/secure/extreme/**' access='ROLE_SUPERVISOR'/>           <intercept-url pattern='/secure/**' access='ROLE_USER'/>           <intercept-url pattern='/**' access='ROLE_USER'/>       </filter-security-metadata-source>   </b:property>   <b:property name='authenticationManager' ref='org.springframework.security.authenticationManager'/></b:bean><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    private FilterInvocation createFilterInvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        request.setMethod(method);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

