/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.PostProcessedMockUserDetailsService;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.openid.OpenID4JavaConsumer;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationFilter;
import org.springframework.security.openid.OpenIDAuthenticationProvider;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.InMemoryTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSecurityBeanDefinitionParserTests {
    private static final int AUTO_CONFIG_FILTERS = 11;
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
        SecurityContextHolder.clearContext();
    }

    @Test
    public void minimalConfigurationParses() {
        this.setContext("<http><http-basic /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void beanClassNamesAreCorrect() throws Exception {
        Assert.assertEquals((Object)DefaultWebSecurityExpressionHandler.class.getName(), (Object)"org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler");
        Assert.assertEquals((Object)ExpressionBasedFilterInvocationSecurityMetadataSource.class.getName(), (Object)"org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource");
        Assert.assertEquals((Object)UsernamePasswordAuthenticationFilter.class.getName(), (Object)"org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter");
        Assert.assertEquals((Object)OpenIDAuthenticationFilter.class.getName(), (Object)"org.springframework.security.openid.OpenIDAuthenticationFilter");
        Assert.assertEquals((Object)OpenIDAuthenticationProvider.class.getName(), (Object)"org.springframework.security.openid.OpenIDAuthenticationProvider");
    }

    @Test
    public void httpAutoConfigSetsUpCorrectFilterList() throws Exception {
        this.setContext("<http auto-config='true' /><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List<Filter> filterList = this.getFilters("/anyurl");
        this.checkAutoConfigFilters(filterList);
        Assert.assertEquals((Object)true, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("org.springframework.security.filterChainProxy"), (String)"stripQueryStringFromUrls"));
        Assert.assertEquals((Object)true, (Object)FieldUtils.getFieldValue((Object)filterList.get(10), (String)"securityMetadataSource.stripQueryStringFromUrls"));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void duplicateElementCausesError() throws Exception {
        this.setContext("<http auto-config='true' /><http auto-config='true' /><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    private void checkAutoConfigFilters(List<Filter> filterList) throws Exception {
        Iterator<Filter> filters = filterList.iterator();
        Assert.assertTrue((boolean)(filters.next() instanceof SecurityContextPersistenceFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof LogoutFilter));
        Filter authProcFilter = filters.next();
        Assert.assertTrue((boolean)(authProcFilter instanceof UsernamePasswordAuthenticationFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof DefaultLoginPageGeneratingFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof BasicAuthenticationFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof RequestCacheAwareFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof SecurityContextHolderAwareRequestFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof AnonymousAuthenticationFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof SessionManagementFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof ExceptionTranslationFilter));
        Filter fsiObj = filters.next();
        Assert.assertTrue((boolean)(fsiObj instanceof FilterSecurityInterceptor));
        FilterSecurityInterceptor fsi = (FilterSecurityInterceptor)fsiObj;
        Assert.assertTrue((boolean)fsi.isObserveOncePerRequest());
    }

    @Test
    public void filterListShouldBeEmptyForPatternWithNoFilters() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/unprotected' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/unprotected");
        Assert.assertTrue((filters.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void filtersEqualsNoneSupportsPlaceholderForPattern() throws Exception {
        System.setProperty("pattern.nofilters", "/unprotected");
        this.setContext("    <b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true'>        <intercept-url pattern='${pattern.nofilters}' filters='none' />        <intercept-url pattern='/**' access='ROLE_A' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/unprotected");
        Assert.assertTrue((filters.size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void filtersEqualsNoneErrorsWithRequiresChannel() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/ambiguousConfig' requires-channel='https' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void filtersEqualsNoneErrorsWithAccess() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/ambiguousConfig' access='ROLE_USER' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void filtersEqualsNoneErrorsWithRequiresChannelAndAccess() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/ambiguousConfig' requires-channel='https' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void regexPathsWorkCorrectly() throws Exception {
        this.setContext("    <http auto-config='true' path-type='regex'>        <intercept-url pattern='\\A\\/[a-z]+' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertEquals((long)0L, (long)this.getFilters("/imlowercase").size());
        List<Filter> allFilters = this.getFilters("/ImCaughtByTheUniversalMatchPattern");
        this.checkAutoConfigFilters(allFilters);
        Assert.assertEquals((Object)false, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("org.springframework.security.filterChainProxy"), (String)"stripQueryStringFromUrls"));
        Assert.assertEquals((Object)false, (Object)FieldUtils.getFieldValue((Object)allFilters.get(10), (String)"securityMetadataSource.stripQueryStringFromUrls"));
    }

    @Test
    public void lowerCaseComparisonAttributeIsRespectedByFilterChainProxy() throws Exception {
        this.setContext("    <http auto-config='true' path-type='ant' lowercase-comparisons='false'>        <intercept-url pattern='/Secure*' filters='none' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertEquals((long)0L, (long)this.getFilters("/Secure").size());
        this.checkAutoConfigFilters(this.getFilters("/secure"));
        this.checkAutoConfigFilters(this.getFilters("/ImCaughtByTheUniversalMatchPattern"));
    }

    @Test
    public void formLoginWithNoLoginPageAddsDefaultLoginPageFilter() throws Exception {
        this.setContext("<http auto-config='true' path-type='ant' lowercase-comparisons='false'>   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.checkAutoConfigFilters(this.getFilters("/anything"));
    }

    @Test
    public void formLoginAlwaysUseDefaultSetsCorrectProperty() throws Exception {
        this.setContext("<http>   <form-login default-target-url='/default' always-use-default-target='true' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        UsernamePasswordAuthenticationFilter filter = this.getFilter(UsernamePasswordAuthenticationFilter.class);
        Assert.assertEquals((Object)"/default", (Object)FieldUtils.getFieldValue((Object)filter, (String)"successHandler.defaultTargetUrl"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"successHandler.alwaysUseDefaultTargetUrl"));
    }

    @Test
    public void anonymousFilterIsAddedByDefault() throws Exception {
        this.setContext("<http>   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertThat(this.getFilters("/anything").get(5), (Matcher)Matchers.instanceOf(AnonymousAuthenticationFilter.class));
    }

    @Test
    public void anonymousFilterIsRemovedIfDisabledFlagSet() throws Exception {
        this.setContext("<http>   <form-login />   <anonymous enabled='false'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertThat(this.getFilters("/anything").get(5), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(AnonymousAuthenticationFilter.class)));
    }

    @Test
    public void anonymousCustomAttributesAreSetCorrectly() throws Exception {
        this.setContext("<http>   <form-login />   <anonymous enabled='true' username='joe' granted-authority='anonymity' key='customKey' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        AnonymousAuthenticationFilter filter = this.getFilter(AnonymousAuthenticationFilter.class);
        Assert.assertEquals((Object)"customKey", (Object)filter.getKey());
        Assert.assertEquals((Object)"joe", (Object)filter.getUserAttribute().getPassword());
        Assert.assertEquals((Object)"anonymity", (Object)((GrantedAuthority)filter.getUserAttribute().getAuthorities().get(0)).getAuthority());
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLoginPageIsDetected() throws Exception {
        this.setContext("<http>   <form-login login-page='noLeadingSlash'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidDefaultTargetUrlIsDetected() throws Exception {
        this.setContext("<http>   <form-login default-target-url='noLeadingSlash'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLogoutUrlIsDetected() throws Exception {
        this.setContext("<http>   <logout logout-url='noLeadingSlash'/>   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLogoutSuccessUrlIsDetected() throws Exception {
        this.setContext("<http>   <logout logout-success-url='noLeadingSlash'/>   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void logoutSuccessHandlerIsSetCorrectly() throws Exception {
        this.setContext("<http>   <logout success-handler-ref='logoutHandler' />   <form-login /></http><b:bean id='logoutHandler' class='org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler' /><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        LogoutFilter filter = this.getFilter(LogoutFilter.class);
        LogoutSuccessHandler handler = (LogoutSuccessHandler)FieldUtils.getFieldValue((Object)filter, (String)"logoutSuccessHandler");
        Assert.assertSame((Object)this.appContext.getBean("logoutHandler"), (Object)handler);
    }

    @Test
    public void lowerCaseComparisonIsRespectedBySecurityFilterInvocationDefinitionSource() throws Exception {
        this.setContext("    <http auto-config='true' path-type='ant' lowercase-comparisons='false'>        <intercept-url pattern='/Secure*' access='ROLE_A, ROLE_B' />        <intercept-url pattern='/**' access='ROLE_C' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterSecurityInterceptor fis = this.getFilter(FilterSecurityInterceptor.class);
        FilterInvocationSecurityMetadataSource fids = fis.getSecurityMetadataSource();
        Collection attrDef = fids.getAttributes((Object)this.createFilterinvocation("/Secure", null));
        Assert.assertEquals((long)2L, (long)attrDef.size());
        Assert.assertTrue((boolean)attrDef.contains(new SecurityConfig("ROLE_A")));
        Assert.assertTrue((boolean)attrDef.contains(new SecurityConfig("ROLE_B")));
        attrDef = fids.getAttributes((Object)this.createFilterinvocation("/secure", null));
        Assert.assertEquals((long)1L, (long)attrDef.size());
        Assert.assertTrue((boolean)attrDef.contains(new SecurityConfig("ROLE_C")));
    }

    @Test
    public void interceptUrlsAndFormLoginSupportPropertyPlaceholders() throws Exception {
        System.setProperty("secure.Url", "/Secure");
        System.setProperty("secure.role", "ROLE_A");
        System.setProperty("login.page", "/loginPage");
        System.setProperty("default.target", "/defaultTarget");
        System.setProperty("auth.failure", "/authFailure");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><http>    <intercept-url pattern='${secure.Url}' access='${secure.role}' />    <intercept-url pattern='${login.page}' filters='none' />    <form-login login-page='${login.page}' default-target-url='${default.target}'         authentication-failure-url='${auth.failure}' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.checkPropertyValues();
        Assert.assertEquals((long)0L, (long)this.getFilters("/loginPage").size());
    }

    @Test
    public void interceptUrlsAndFormLoginSupportEL() throws Exception {
        System.setProperty("secure.url", "/Secure");
        System.setProperty("secure.role", "ROLE_A");
        System.setProperty("login.page", "/loginPage");
        System.setProperty("default.target", "/defaultTarget");
        System.setProperty("auth.failure", "/authFailure");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><http>    <intercept-url pattern=\"#{systemProperties['secure.url']}\" access=\"#{systemProperties['secure.role']}\" />    <form-login login-page=\"#{systemProperties['login.page']}\" default-target-url=\"#{systemProperties['default.target']}\"         authentication-failure-url=\"#{systemProperties['auth.failure']}\" /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.checkPropertyValues();
    }

    private void checkPropertyValues() throws Exception {
        FilterSecurityInterceptor fis = this.getFilter(FilterSecurityInterceptor.class);
        FilterInvocationSecurityMetadataSource fids = fis.getSecurityMetadataSource();
        Collection attrs = fids.getAttributes((Object)this.createFilterinvocation("/secure", null));
        Assert.assertNotNull((Object)attrs);
        Assert.assertEquals((long)1L, (long)attrs.size());
        Assert.assertTrue((boolean)attrs.contains(new SecurityConfig("ROLE_A")));
        UsernamePasswordAuthenticationFilter apf = this.getFilter(UsernamePasswordAuthenticationFilter.class);
        Assert.assertEquals((Object)"/defaultTarget", (Object)FieldUtils.getFieldValue((Object)apf, (String)"successHandler.defaultTargetUrl"));
        Assert.assertEquals((Object)"/authFailure", (Object)FieldUtils.getFieldValue((Object)apf, (String)"failureHandler.defaultFailureUrl"));
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/loginPage", (Object)FieldUtils.getFieldValue((Object)etf, (String)"authenticationEntryPoint.loginFormUrl"));
    }

    @Test
    public void httpMethodMatchIsSupported() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/**' access='ROLE_C' />        <intercept-url pattern='/secure*' method='DELETE' access='ROLE_SUPERVISOR' />        <intercept-url pattern='/secure*' method='POST' access='ROLE_A,ROLE_B' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterSecurityInterceptor fis = this.getFilter(FilterSecurityInterceptor.class);
        FilterInvocationSecurityMetadataSource fids = fis.getSecurityMetadataSource();
        Collection attrs = fids.getAttributes((Object)this.createFilterinvocation("/secure", "POST"));
        Assert.assertEquals((long)2L, (long)attrs.size());
        Assert.assertTrue((boolean)attrs.contains(new SecurityConfig("ROLE_A")));
        Assert.assertTrue((boolean)attrs.contains(new SecurityConfig("ROLE_B")));
    }

    @Test
    public void httpMethodMatchIsSupportedForRequiresChannel() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/anyurl'/>        <intercept-url pattern='/anyurl' method='GET' access='ROLE_ADMIN' requires-channel='https' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ChannelProcessingFilter filter = this.getFilter(ChannelProcessingFilter.class);
        FilterInvocationSecurityMetadataSource fids = (FilterInvocationSecurityMetadataSource)FieldUtils.getFieldValue((Object)filter, (String)"securityMetadataSource");
        Collection attrs = fids.getAttributes((Object)this.createFilterinvocation("/anyurl", "GET"));
        Assert.assertEquals((long)1L, (long)attrs.size());
        attrs = fids.getAttributes((Object)this.createFilterinvocation("/anyurl", "POST"));
        Assert.assertEquals(null, (Object)attrs);
    }

    @Test
    public void oncePerRequestAttributeIsSupported() throws Exception {
        this.setContext("<http once-per-request='false'><http-basic /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterSecurityInterceptor fsi = this.getFilter(FilterSecurityInterceptor.class);
        Assert.assertFalse((boolean)fsi.isObserveOncePerRequest());
    }

    @Test
    public void httpBasicSupportsSeparateEntryPoint() throws Exception {
        this.setContext("<http><http-basic entry-point-ref='ep' /></http><b:bean id='ep' class='org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint'>    <b:property name='realmName' value='whocares'/></b:bean><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        BasicAuthenticationFilter baf = this.getFilter(BasicAuthenticationFilter.class);
        Assert.assertSame((Object)this.appContext.getBean("ep"), (Object)FieldUtils.getFieldValue((Object)baf, (String)"authenticationEntryPoint"));
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertSame((Object)this.appContext.getBean("ep"), (Object)FieldUtils.getFieldValue((Object)etf, (String)"authenticationEntryPoint"));
    }

    @Test
    public void accessDeniedPageAttributeIsSupported() throws Exception {
        this.setContext("<http access-denied-page='/access-denied'><http-basic /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/access-denied", (Object)FieldUtils.getFieldValue((Object)etf, (String)"accessDeniedHandler.errorPage"));
    }

    @Test(expected=BeanCreationException.class)
    public void invalidAccessDeniedUrlIsDetected() throws Exception {
        this.setContext("<http auto-config='true' access-denied-page='noLeadingSlash'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void interceptUrlWithRequiresChannelAddsChannelFilterToStack() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/**' requires-channel='https' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/someurl");
        Assert.assertEquals((String)"Expected 12  filters in chain", (long)12L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof ChannelProcessingFilter));
    }

    @Test
    public void requiresChannelSupportsPlaceholder() throws Exception {
        System.setProperty("secure.url", "/secure");
        System.setProperty("required.channel", "https");
        this.setContext("    <b:bean id='configurer' class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true'>        <intercept-url pattern='${secure.url}' requires-channel='${required.channel}' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/secure");
        Assert.assertTrue((boolean)(filters.get(0) instanceof ChannelProcessingFilter));
        ChannelProcessingFilter filter = (ChannelProcessingFilter)filters.get(0);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure");
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertNotNull((Object)response.getRedirectedUrl());
        Assert.assertTrue((boolean)response.getRedirectedUrl().startsWith("https"));
    }

    @Test
    public void portMappingsAreParsedCorrectly() throws Exception {
        this.setContext("    <http auto-config='true'>        <port-mappings>            <port-mapping http='9080' https='9443'/>        </port-mappings>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        PortMapperImpl pm = this.getPortMapper();
        Assert.assertEquals((long)1L, (long)pm.getTranslatedPortMappings().size());
        Assert.assertEquals((Object)9080, (Object)pm.lookupHttpPort(Integer.valueOf(9443)));
        Assert.assertEquals((Object)9443, (Object)pm.lookupHttpsPort(Integer.valueOf(9080)));
    }

    @Test
    public void portMappingsWorkWithPlaceholdersAndEL() throws Exception {
        System.setProperty("http", "9080");
        System.setProperty("https", "9443");
        this.setContext("    <b:bean id='configurer' class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true'>        <port-mappings>            <port-mapping http='#{systemProperties.http}' https='${https}'/>        </port-mappings>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        PortMapperImpl pm = this.getPortMapper();
        Assert.assertEquals((long)1L, (long)pm.getTranslatedPortMappings().size());
        Assert.assertEquals((Object)9080, (Object)pm.lookupHttpPort(Integer.valueOf(9443)));
        Assert.assertEquals((Object)9443, (Object)pm.lookupHttpsPort(Integer.valueOf(9080)));
    }

    private PortMapperImpl getPortMapper() {
        Map beans = this.appContext.getBeansOfType(PortMapperImpl.class);
        return (PortMapperImpl)new ArrayList(beans.values()).get(0);
    }

    @Test
    public void accessDeniedPageWorksWithPlaceholders() throws Exception {
        System.setProperty("accessDenied", "/go-away");
        this.setContext("    <b:bean id='configurer' class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true' access-denied-page='${accessDenied}'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter filter = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/go-away", (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler.errorPage"));
    }

    @Test
    public void accessDeniedHandlerPageWorksWithEL() throws Exception {
        this.setContext("    <http auto-config='true'>        <access-denied-handler error-page=\"#{'/go' + '-away'} \" />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter filter = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/go-away", (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler.errorPage"));
    }

    @Test
    public void accessDeniedHandlerIsSetCorectly() throws Exception {
        this.setContext("    <b:bean id='adh' class='" + AccessDeniedHandlerImpl.class.getName() + "'/>" + "    <http auto-config='true'>" + "        <access-denied-handler ref='adh'/>" + "    </http>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter filter = this.getFilter(ExceptionTranslationFilter.class);
        AccessDeniedHandlerImpl adh = (AccessDeniedHandlerImpl)this.appContext.getBean("adh");
        Assert.assertSame((Object)adh, (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler"));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void accessDeniedPageAndAccessDeniedHandlerAreMutuallyExclusive() throws Exception {
        this.setContext("    <http auto-config='true' access-denied-page='/go-away'>        <access-denied-handler error-page='/go-away'/>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter filter = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/go-away", (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler.errorPage"));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void accessDeniedHandlerPageAndRefAreMutuallyExclusive() throws Exception {
        this.setContext("    <b:bean id='adh' class='" + AccessDeniedHandlerImpl.class.getName() + "'/>" + "    <http auto-config='true'>" + "        <access-denied-handler error-page='/go-away' ref='adh'/>" + "    </http>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter filter = this.getFilter(ExceptionTranslationFilter.class);
        Assert.assertEquals((Object)"/go-away", (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler.errorPage"));
    }

    @Test
    public void externalFiltersAreTreatedCorrectly() throws Exception {
        String contextHolderFilterClass = SecurityContextHolderAwareRequestFilter.class.getName();
        String contextPersistenceFilterClass = SecurityContextPersistenceFilter.class.getName();
        System.setProperty("customFilterRef", "userFilter1");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><http auto-config='true'>    <custom-filter position='FIRST' ref='${customFilterRef}' />    <custom-filter after='LOGOUT_FILTER' ref='userFilter' />    <custom-filter before='SECURITY_CONTEXT_FILTER' ref='userFilter3'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager><b:bean id='userFilter' class='" + contextHolderFilterClass + "'/>" + "<b:bean id='userFilter1' class='" + contextPersistenceFilterClass + "'/>" + "<b:bean id='userFilter2' class='" + contextPersistenceFilterClass + "'/>" + "<b:bean id='userFilter3' class='" + contextPersistenceFilterClass + "'/>" + "<b:bean id='userFilter4' class='" + contextHolderFilterClass + "'/>");
        List filters = this.getFilters("/someurl");
        Assert.assertEquals((long)14L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof SecurityContextPersistenceFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SecurityContextPersistenceFilter));
        Assert.assertTrue((boolean)(filters.get(4) instanceof SecurityContextHolderAwareRequestFilter));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void twoFiltersWithSameOrderAreRejected() {
        this.setContext("<http auto-config='true'>    <custom-filter position='LOGOUT_FILTER' ref='userFilter'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager><b:bean id='userFilter' class='" + SecurityContextHolderAwareRequestFilter.class.getName() + "'/>");
    }

    @Test
    public void rememberMeServiceWorksWithTokenRepoRef() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me token-repository-ref='tokenRepo'/></http><b:bean id='tokenRepo' class='" + InMemoryTokenRepositoryImpl.class.getName() + "'/> " + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        RememberMeServices rememberMeServices = this.getRememberMeServices();
        Assert.assertTrue((boolean)(rememberMeServices instanceof PersistentTokenBasedRememberMeServices));
        Assert.assertFalse((boolean)((Boolean)FieldUtils.getFieldValue((Object)this.getRememberMeServices(), (String)"useSecureCookie")));
    }

    @Test
    public void rememberMeServiceWorksWithDataSourceRef() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me data-source-ref='ds'/></http><b:bean id='ds' class='org.springframework.security.TestDataSource'>     <b:constructor-arg value='tokendb'/></b:bean><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        RememberMeServices rememberMeServices = this.getRememberMeServices();
        Assert.assertTrue((boolean)(rememberMeServices instanceof PersistentTokenBasedRememberMeServices));
    }

    @Test
    public void rememberMeServiceWorksWithExternalServicesImpl() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key=\"#{'our' + 'key'}\" services-ref='rms'/></http><b:bean id='rms' class='" + TokenBasedRememberMeServices.class.getName() + "'> " + "    <b:property name='userDetailsService' ref='us'/>" + "    <b:property name='key' value='ourkey' />" + "    <b:property name='tokenValiditySeconds' value='5000'/>" + "</b:bean>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertEquals((Object)5000, (Object)FieldUtils.getFieldValue((Object)this.getRememberMeServices(), (String)"tokenValiditySeconds"));
        List logoutHandlers = (List)FieldUtils.getFieldValue((Object)this.getFilter(LogoutFilter.class), (String)"handlers");
        Assert.assertEquals((long)2L, (long)logoutHandlers.size());
        Assert.assertEquals((Object)this.getRememberMeServices(), logoutHandlers.get(1));
        Map ams = this.appContext.getBeansOfType(ProviderManager.class);
        ams.remove("org.springframework.security.authenticationManager");
        RememberMeAuthenticationProvider rmp = (RememberMeAuthenticationProvider)((ProviderManager)ams.values().toArray()[0]).getProviders().get(1);
        Assert.assertEquals((Object)"ourkey", (Object)rmp.getKey());
    }

    @Test
    public void rememberMeTokenValidityIsParsedCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key='ourkey' token-validity-seconds='10000' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertEquals((Object)10000, (Object)FieldUtils.getFieldValue((Object)this.getRememberMeServices(), (String)"tokenValiditySeconds"));
    }

    @Test
    public void rememberMeTokenValidityAllowsNegativeValueForNonPersistentImplementation() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key='ourkey' token-validity-seconds='-1' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertEquals((Object)-1, (Object)FieldUtils.getFieldValue((Object)this.getRememberMeServices(), (String)"tokenValiditySeconds"));
    }

    @Test
    public void rememberMeSecureCookieAttributeIsSetCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key='ourkey' use-secure-cookie='true' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertTrue((boolean)((Boolean)FieldUtils.getFieldValue((Object)this.getRememberMeServices(), (String)"useSecureCookie")));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void rememberMeTokenValidityRejectsNegativeValueForPersistentImplementation() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me token-validity-seconds='-1' token-repository-ref='tokenRepo'/></http><b:bean id='tokenRepo' class='org.springframework.security.ui.rememberme.InMemoryTokenRepositoryImpl'/> <authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void rememberMeServiceConfigurationParsesWithCustomUserService() {
        this.setContext("<http auto-config='true'>    <remember-me key='somekey' user-service-ref='userService'/></http><b:bean id='userService' class='org.springframework.security.core.userdetails.MockUserDetailsService'/> <authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void x509SupportAddsFilterAtExpectedPosition() throws Exception {
        this.setContext("<http auto-config='true'>    <x509 /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/someurl");
        Assert.assertTrue((boolean)(filters.get(2) instanceof X509AuthenticationFilter));
    }

    @Test
    public void x509SubjectPrincipalRegexCanBeSetUsingPropertyPlaceholder() throws Exception {
        System.setProperty("subject-principal-regex", "uid=(.*),");
        this.setContext("<b:bean class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/><http auto-config='true'>    <x509 subject-principal-regex='${subject-principal-regex}'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        X509AuthenticationFilter filter = this.getFilter(X509AuthenticationFilter.class);
        SubjectDnX509PrincipalExtractor pe = (SubjectDnX509PrincipalExtractor)FieldUtils.getFieldValue((Object)filter, (String)"principalExtractor");
        Pattern p = (Pattern)FieldUtils.getFieldValue((Object)pe, (String)"subjectDnPattern");
        Assert.assertEquals((Object)"uid=(.*),", (Object)p.pattern());
    }

    @Test
    public void concurrentSessionSupportAddsFilterAndExpectedBeans() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management>        <concurrency-control session-registry-alias='sr' expired-url='/expired'/>    </session-management></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/someurl");
        Assert.assertTrue((boolean)(filters.get(0) instanceof ConcurrentSessionFilter));
        Assert.assertNotNull((Object)this.appContext.getBean("sr"));
        SessionManagementFilter smf = this.getFilter(SessionManagementFilter.class);
        Assert.assertNotNull((Object)smf);
        this.checkSessionRegistry();
    }

    @Test
    public void externalSessionStrategyIsSupported() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management session-authentication-strategy-ref='ss'/></http><b:bean id='ss' class='org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void externalSessionRegistryBeanIsConfiguredCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management>        <concurrency-control session-registry-ref='sr' />    </session-management></http><b:bean id='sr' class='" + SessionRegistryImpl.class.getName() + "'/>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.checkSessionRegistry();
    }

    private void checkSessionRegistry() throws Exception {
        Object sessionRegistry = this.appContext.getBean("sr");
        Object sessionRegistryFromConcurrencyFilter = FieldUtils.getFieldValue((Object)this.getFilter(ConcurrentSessionFilter.class), (String)"sessionRegistry");
        Object sessionRegistryFromFormLoginFilter = FieldUtils.getFieldValue((Object)this.getFilter(UsernamePasswordAuthenticationFilter.class), (String)"sessionStrategy.sessionRegistry");
        Object sessionRegistryFromMgmtFilter = FieldUtils.getFieldValue((Object)this.getFilter(SessionManagementFilter.class), (String)"sessionStrategy.sessionRegistry");
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromConcurrencyFilter);
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromMgmtFilter);
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromFormLoginFilter);
    }

    @Test
    public void concurrentSessionMaxSessionsIsCorrectlyConfigured() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management session-authentication-error-url='/max-exceeded'>        <concurrency-control max-sessions='2' error-if-maximum-exceeded='true' />    </session-management></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SessionManagementFilter seshFilter = this.getFilter(SessionManagementFilter.class);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"pass");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        SaveContextOnUpdateOrErrorResponseWrapper response = new SaveContextOnUpdateOrErrorResponseWrapper((HttpServletResponse)mockResponse, false){

            protected void saveContext(SecurityContext context) {
            }
        };
        seshFilter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)mockResponse.getRedirectedUrl());
        seshFilter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)mockResponse.getRedirectedUrl());
        seshFilter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertEquals((Object)"/max-exceeded", (Object)mockResponse.getRedirectedUrl());
    }

    @Test
    public void externalRequestCacheIsConfiguredCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <request-cache ref='cache' /></http><b:bean id='cache' class='" + HttpSessionRequestCache.class.getName() + "'/>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Object requestCache = this.appContext.getBean("cache");
        Assert.assertSame((Object)requestCache, (Object)FieldUtils.getFieldValue((Object)this.getFilter(ExceptionTranslationFilter.class), (String)"requestCache"));
    }

    @Test
    public void customEntryPointIsSupported() throws Exception {
        this.setContext("<http auto-config='true' entry-point-ref='entryPoint'/><b:bean id='entryPoint' class='" + MockEntryPoint.class.getName() + "'>" + "</b:bean>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Assert.assertTrue((String)"ExceptionTranslationFilter should be configured with custom entry point", (boolean)(this.getFilter(ExceptionTranslationFilter.class).getAuthenticationEntryPoint() instanceof MockEntryPoint));
    }

    @Test
    public void rememberMeServicesWorksWithoutBasicProcessingFilter() {
        this.setContext("    <http>        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>        <logout logout-success-url='/login.jsp'/>        <anonymous username='guest' granted-authority='guest'/>        <remember-me />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void disablingSessionProtectionRemovesSessionManagementFilterIfNoInvalidSessionUrlSet() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management session-fixation-protection='none'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/someurl");
        Assert.assertFalse((boolean)(filters.get(8) instanceof SessionManagementFilter));
    }

    @Test
    public void disablingSessionProtectionRetainsSessionManagementFilterInvalidSessionUrlSet() throws Exception {
        this.setContext("<http auto-config='true'>    <session-management session-fixation-protection='none' invalid-session-url='/timeoutUrl'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        List filters = this.getFilters("/someurl");
        Object filter = filters.get(8);
        Assert.assertTrue((boolean)(filter instanceof SessionManagementFilter));
        Assert.assertEquals((Object)"/timeoutUrl", (Object)FieldUtils.getProtectedFieldValue((String)"invalidSessionUrl", filter));
    }

    @Test
    public void httpElementDoesntInterfereWithBeanPostProcessing() {
        this.setContext("<http auto-config='true'/><authentication-manager>   <authentication-provider user-service-ref='myUserService'/></authentication-manager><b:bean id='myUserService' class='org.springframework.security.config.PostProcessedMockUserDetailsService'/><b:bean id='beanPostProcessor' class='org.springframework.security.config.MockUserServiceBeanPostProcessor'/>");
        PostProcessedMockUserDetailsService service = (PostProcessedMockUserDetailsService)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)"Hello from the post processor!", (Object)service.getPostProcessorWasHere());
    }

    @Test
    public void unprotectedLoginPageDoesntResultInWarning() {
        this.setContext("    <http>        <intercept-url pattern='/login.jsp*' access='IS_AUTHENTICATED_ANONYMOUSLY'/>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.closeAppContext();
        this.setContext("    <http>        <intercept-url pattern='/login.jsp*' filters='none'/>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void protectedLoginPageResultsInWarning() {
        this.setContext("    <http>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous enabled='false' />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.closeAppContext();
        this.setContext("    <http>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void settingCreateSessionToAlwaysSetsFilterPropertiesCorrectly() throws Exception {
        this.setContext("<http auto-config='true' create-session='always'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextPersistenceFilter filter = this.getFilter(SecurityContextPersistenceFilter.class);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"forceEagerSessionCreation"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo.allowSessionCreation"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo.disableUrlRewriting"));
    }

    @Test
    public void settingCreateSessionToNeverSetsFilterPropertiesCorrectly() throws Exception {
        this.setContext("<http auto-config='true' create-session='never'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextPersistenceFilter filter = this.getFilter(SecurityContextPersistenceFilter.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"forceEagerSessionCreation"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo.allowSessionCreation"));
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/anything");
        fcp.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void settingCreateSessionToIfRequiredDoesntCreateASessionForPublicInvocation() throws Exception {
        this.setContext("<http auto-config='true' create-session='ifRequired'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextPersistenceFilter filter = this.getFilter(SecurityContextPersistenceFilter.class);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"forceEagerSessionCreation"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo.allowSessionCreation"));
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/anything");
        fcp.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void supportsTwoIdenticalInterceptUrls() throws Exception {
        this.setContext("<http auto-config='true'>    <intercept-url pattern='/someurl' access='ROLE_A'/>    <intercept-url pattern='/someurl' access='ROLE_B'/></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterSecurityInterceptor fis = this.getFilter(FilterSecurityInterceptor.class);
        FilterInvocationSecurityMetadataSource fids = fis.getSecurityMetadataSource();
        Collection attrDef = fids.getAttributes((Object)this.createFilterinvocation("/someurl", null));
        Assert.assertEquals((long)1L, (long)attrDef.size());
        Assert.assertTrue((boolean)attrDef.contains(new SecurityConfig("ROLE_B")));
    }

    @Test
    public void supportsExternallyDefinedSecurityContextRepository() throws Exception {
        this.setContext("<b:bean id='repo' class='" + HttpSessionSecurityContextRepository.class.getName() + "'/>" + "<http create-session='always' security-context-repository-ref='repo'>" + "    <http-basic />" + "</http>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextPersistenceFilter filter = this.getFilter(SecurityContextPersistenceFilter.class);
        HttpSessionSecurityContextRepository repo = (HttpSessionSecurityContextRepository)this.appContext.getBean("repo");
        Assert.assertSame((Object)repo, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo"));
        Assert.assertTrue((boolean)((Boolean)FieldUtils.getFieldValue((Object)filter, (String)"forceEagerSessionCreation")));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void cantUseUnsupportedSessionCreationAttributeWithExternallyDefinedSecurityContextRepository() throws Exception {
        this.setContext("<b:bean id='repo' class='" + HttpSessionSecurityContextRepository.class.getName() + "'/>" + "<http create-session='never' security-context-repository-ref='repo'>" + "    <http-basic />" + "</http>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void expressionBasedAccessAllowsAndDeniesAccessAsExpected() throws Exception {
        this.setContext("    <http auto-config='true' use-expressions='true'>        <intercept-url pattern='/secure*' access=\"hasAnyRole('ROLE_A','ROLE_C')\" />        <intercept-url pattern='/**' access='permitAll()' />    </http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterSecurityInterceptor fis = this.getFilter(FilterSecurityInterceptor.class);
        FilterInvocationSecurityMetadataSource fids = fis.getSecurityMetadataSource();
        Collection attrDef = fids.getAttributes((Object)this.createFilterinvocation("/secure", null));
        Assert.assertEquals((long)1L, (long)attrDef.size());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"joe", (Object)"", new String[]{"ROLE_A"}));
        fis.invoke(this.createFilterinvocation("/permitallurl", null));
        fis.invoke(this.createFilterinvocation("/securex", null));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"joe", (Object)"", new String[]{"ROLE_B"}));
        try {
            fis.invoke(this.createFilterinvocation("/securex", null));
            Assert.fail((String)"Expected AccessDeniedInvocation");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
    }

    @Test
    public void customSuccessAndFailureHandlersCanBeSetThroughTheNamespace() throws Exception {
        this.setContext("<http>   <form-login authentication-success-handler-ref='sh' authentication-failure-handler-ref='fh'/></http><b:bean id='sh' class='" + SavedRequestAwareAuthenticationSuccessHandler.class.getName() + "'/>" + "<b:bean id='fh' class='" + SimpleUrlAuthenticationFailureHandler.class.getName() + "'/>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        UsernamePasswordAuthenticationFilter apf = this.getFilter(UsernamePasswordAuthenticationFilter.class);
        AuthenticationSuccessHandler sh = (AuthenticationSuccessHandler)this.appContext.getBean("sh");
        AuthenticationFailureHandler fh = (AuthenticationFailureHandler)this.appContext.getBean("fh");
        Assert.assertSame((Object)sh, (Object)FieldUtils.getFieldValue((Object)apf, (String)"successHandler"));
        Assert.assertSame((Object)fh, (Object)FieldUtils.getFieldValue((Object)apf, (String)"failureHandler"));
    }

    @Test
    public void disablingUrlRewritingThroughTheNamespaceSetsCorrectPropertyOnContextRepo() throws Exception {
        this.setContext("<http auto-config='true' disable-url-rewriting='true'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextPersistenceFilter filter = this.getFilter(SecurityContextPersistenceFilter.class);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"repo.disableUrlRewriting"));
    }

    @Test
    public void userDetailsServiceInParentContextIsLocatedSuccessfully() throws Exception {
        this.appContext = new InMemoryXmlApplicationContext("<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.appContext = new InMemoryXmlApplicationContext("<http auto-config='true'>    <remember-me /></http>", (ApplicationContext)this.appContext);
    }

    @Test
    public void openIDAndFormLoginWorkTogether() throws Exception {
        this.setContext("<http>   <openid-login />   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        LoginUrlAuthenticationEntryPoint ap = (LoginUrlAuthenticationEntryPoint)etf.getAuthenticationEntryPoint();
        Assert.assertEquals((Object)"/spring_security_login", (Object)ap.getLoginFormUrl());
        this.getFilter(DefaultLoginPageGeneratingFilter.class);
    }

    @Test
    public void openIDAndRememberMeWorkTogether() throws Exception {
        this.setContext("<http>   <intercept-url pattern='/**' access='ROLE_NOBODY'/>   <openid-login />   <remember-me /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        DefaultLoginPageGeneratingFilter loginFilter = this.getFilter(DefaultLoginPageGeneratingFilter.class);
        OpenIDAuthenticationFilter openIDFilter = this.getFilter(OpenIDAuthenticationFilter.class);
        openIDFilter.setConsumer(new OpenIDConsumer(){

            public String beginConsumption(HttpServletRequest req, String claimedIdentity, String returnToUrl, String realm) throws OpenIDConsumerException {
                return "http://testopenid.com?openid.return_to=" + returnToUrl;
            }

            public OpenIDAuthenticationToken endConsumption(HttpServletRequest req) throws OpenIDConsumerException {
                throw new UnsupportedOperationException();
            }
        });
        HashSet<String> returnToUrlParameters = new HashSet<String>();
        returnToUrlParameters.add("_spring_security_remember_me");
        openIDFilter.setReturnToUrlParameters(returnToUrlParameters);
        Assert.assertNotNull((Object)FieldUtils.getFieldValue((Object)loginFilter, (String)"openIDrememberMeParameter"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        request.setServletPath("/something.html");
        fcp.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertTrue((boolean)response.getRedirectedUrl().endsWith("/spring_security_login"));
        request.setServletPath("/spring_security_login");
        request.setRequestURI("/spring_security_login");
        response = new MockHttpServletResponse();
        fcp.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertTrue((boolean)response.getContentAsString().contains("_spring_security_remember_me"));
        request.setRequestURI("/j_spring_openid_security_check");
        request.setParameter("openid_identifier", "http://hey.openid.com/");
        request.setParameter("_spring_security_remember_me", "on");
        response = new MockHttpServletResponse();
        fcp.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        String expectedReturnTo = request.getRequestURL().append("?").append("_spring_security_remember_me").append("=").append("on").toString();
        Assert.assertEquals((Object)("http://testopenid.com?openid.return_to=" + expectedReturnTo), (Object)response.getRedirectedUrl());
    }

    @Test
    public void formLoginEntryPointTakesPrecedenceIfLoginUrlIsSet() throws Exception {
        this.setContext("<http>   <openid-login />   <form-login login-page='/form_login_page' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        LoginUrlAuthenticationEntryPoint ap = (LoginUrlAuthenticationEntryPoint)etf.getAuthenticationEntryPoint();
        Assert.assertEquals((Object)"/form_login_page", (Object)ap.getLoginFormUrl());
        try {
            this.getFilter(DefaultLoginPageGeneratingFilter.class);
            Assert.fail((String)"Login page generating filter shouldn't be present");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void openIDEntryPointTakesPrecedenceIfLoginUrlIsSet() throws Exception {
        this.setContext("<http>   <openid-login login-page='/openid_login' />   <form-login /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class);
        LoginUrlAuthenticationEntryPoint ap = (LoginUrlAuthenticationEntryPoint)etf.getAuthenticationEntryPoint();
        Assert.assertEquals((Object)"/openid_login", (Object)ap.getLoginFormUrl());
    }

    @Test
    public void openIDWithAttributeExchangeConfigurationIsParsedCorrectly() throws Exception {
        this.setContext("<http>   <openid-login>      <attribute-exchange>          <openid-attribute name='nickname' type='http://schema.openid.net/namePerson/friendly'/>          <openid-attribute name='email' type='http://schema.openid.net/contact/email' required='true' count='2'/>      </attribute-exchange>   </openid-login></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        OpenIDAuthenticationFilter apf = this.getFilter(OpenIDAuthenticationFilter.class);
        OpenID4JavaConsumer consumer = (OpenID4JavaConsumer)FieldUtils.getFieldValue((Object)apf, (String)"consumer");
        List attributes = (List)FieldUtils.getFieldValue((Object)consumer, (String)"attributesToFetch");
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertEquals((Object)"nickname", (Object)((OpenIDAttribute)attributes.get(0)).getName());
        Assert.assertEquals((Object)"http://schema.openid.net/namePerson/friendly", (Object)((OpenIDAttribute)attributes.get(0)).getType());
        Assert.assertFalse((boolean)((OpenIDAttribute)attributes.get(0)).isRequired());
        Assert.assertTrue((boolean)((OpenIDAttribute)attributes.get(1)).isRequired());
        Assert.assertEquals((long)2L, (long)((OpenIDAttribute)attributes.get(1)).getCount());
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void multipleLoginPagesCausesError() throws Exception {
        this.setContext("<http>   <openid-login login-page='/openid_login_page' />   <form-login login-page='/form_login_page' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test
    public void httpConfigWithNoAuthProvidersWorksOk() throws Exception {
        this.setContext("<http>   <form-login />   <anonymous enabled='false' /></http><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/j_spring_security_check");
        request.setServletPath("/j_spring_security_check");
        request.addParameter("j_username", "bob");
        request.addParameter("j_password", "bob");
        fcp.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }

    @Test
    public void httpFirewallInjectionIsSupported() throws Exception {
        this.setContext("<http-firewall ref='fw'/><http>   <form-login /></http><b:bean id='fw' class='" + DefaultHttpFirewall.class.getName() + "'/>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        Assert.assertSame((Object)this.appContext.getBean("fw"), (Object)FieldUtils.getFieldValue((Object)fcp, (String)"firewall"));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    private <T extends Filter> List<T> getFilters(String url) throws Exception {
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("org.springframework.security.filterChainProxy");
        Method getFilters = fcp.getClass().getDeclaredMethod("getFilters", String.class);
        getFilters.setAccessible(true);
        return (List)ReflectionUtils.invokeMethod((Method)getFilters, (Object)fcp, (Object[])new Object[]{url});
    }

    private FilterInvocation createFilterinvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(method);
        request.setRequestURI(null);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }

    private <T extends Filter> T getFilter(Class<T> type) throws Exception {
        List<T> filters = this.getFilters("/any");
        for (Filter f : filters) {
            if (!f.getClass().isAssignableFrom(type)) continue;
            return (T)f;
        }
        throw new Exception("Filter not found");
    }

    private RememberMeServices getRememberMeServices() throws Exception {
        return this.getFilter(RememberMeAuthenticationFilter.class).getRememberMeServices();
    }

    private static class MockEntryPoint
    extends LoginUrlAuthenticationEntryPoint {
        public MockEntryPoint() {
            super.setLoginFormUrl("/notused");
        }
    }
}

