/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContextException;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.security.util.FieldUtils;

public class LdapProviderBeanDefinitionParserTests {
    InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void beanClassNamesAreCorrect() throws Exception {
        Assert.assertEquals((Object)"org.springframework.security.ldap.authentication.LdapAuthenticationProvider", (Object)LdapAuthenticationProvider.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.authentication.BindAuthenticator", (Object)BindAuthenticator.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator", (Object)PasswordComparisonAuthenticator.class.getName());
    }

    @Test
    public void multipleProvidersAreSupported() throws Exception {
        this.setContext("<ldap-server url='ldap://blah:389/dc=blah'/><authentication-manager>   <ldap-authentication-provider group-search-filter='member={0}' />   <ldap-authentication-provider group-search-filter='uniqueMember={0}' /></authentication-manager>");
        ProviderManager authManager = (ProviderManager)this.appCtx.getBean("org.springframework.security.authenticationManager");
        Assert.assertEquals((long)2L, (long)authManager.getProviders().size());
        Assert.assertEquals((Object)"member={0}", (Object)FieldUtils.getFieldValue(authManager.getProviders().get(0), (String)"authoritiesPopulator.groupSearchFilter"));
        Assert.assertEquals((Object)"uniqueMember={0}", (Object)FieldUtils.getFieldValue(authManager.getProviders().get(1), (String)"authoritiesPopulator.groupSearchFilter"));
    }

    @Test
    public void simpleProviderAuthenticatesCorrectly() {
        this.setContext("<ldap-server /><authentication-manager>   <ldap-authentication-provider group-search-filter='member={0}' /></authentication-manager>");
        LdapAuthenticationProvider provider = this.getProvider();
        Authentication auth = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword"));
        LdapUserDetailsImpl ben = (LdapUserDetailsImpl)auth.getPrincipal();
        Assert.assertEquals((long)3L, (long)ben.getAuthorities().size());
    }

    @Test(expected=ApplicationContextException.class)
    public void missingServerEltCausesConfigException() {
        this.setContext("<authentication-manager>   <ldap-authentication-provider /></authentication-manager>");
    }

    @Test
    public void supportsPasswordComparisonAuthentication() {
        this.setContext("<ldap-server /> <authentication-manager><ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare /></ldap-authentication-provider></authentication-manager>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword"));
    }

    @Test
    public void supportsPasswordComparisonAuthenticationWithHashAttribute() {
        this.setContext("<ldap-server /> <authentication-manager><ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare password-attribute='uid' hash='plaintext'/></ldap-authentication-provider></authentication-manager>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"ben"));
    }

    @Test
    public void supportsPasswordComparisonAuthenticationWithPasswordEncoder() {
        this.setContext("<ldap-server /> <authentication-manager><ldap-authentication-provider user-dn-pattern='uid={0},ou=people'>    <password-compare password-attribute='uid'>        <password-encoder hash='plaintext'/>    </password-compare></ldap-authentication-provider></authentication-manager>");
        LdapAuthenticationProvider provider = this.getProvider();
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"ben"));
    }

    @Test
    public void detectsNonStandardServerId() {
        this.setContext("<ldap-server id='myServer'/> <authentication-manager>  <ldap-authentication-provider /></authentication-manager>");
    }

    @Test
    public void inetOrgContextMapperIsSupported() throws Exception {
        this.setContext("<ldap-server id='someServer' url='ldap://127.0.0.1:343/dc=springframework,dc=org'/><authentication-manager>    <ldap-authentication-provider user-details-class='inetOrgPerson'/></authentication-manager>");
        LdapAuthenticationProvider provider = this.getProvider();
        Assert.assertTrue((boolean)(FieldUtils.getFieldValue((Object)provider, (String)"userDetailsContextMapper") instanceof InetOrgPersonContextMapper));
    }

    private void setContext(String context) {
        this.appCtx = new InMemoryXmlApplicationContext(context);
    }

    private LdapAuthenticationProvider getProvider() {
        ProviderManager authManager = (ProviderManager)this.appCtx.getBean("org.springframework.security.authenticationManager");
        Assert.assertEquals((long)1L, (long)authManager.getProviders().size());
        LdapAuthenticationProvider provider = (LdapAuthenticationProvider)authManager.getProviders().get(0);
        return provider;
    }
}

