/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.junit.After;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

public class LdapServerBeanDefinitionParserTests {
    InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void embeddedServerCreationContainsExpectedContextSourceAndData() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server />");
        DefaultSpringSecurityContextSource contextSource = (DefaultSpringSecurityContextSource)this.appCtx.getBean("org.springframework.security.securityContextSource");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=ben,ou=people");
    }

    @Test
    public void useOfUrlAttributeCreatesCorrectContextSource() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server port='33388'/><ldap-server id='blah' url='ldap://127.0.0.1:33388/dc=springframework,dc=org' />");
        this.appCtx.getBean("org.springframework.security.securityContextSource");
        DefaultSpringSecurityContextSource contextSource = (DefaultSpringSecurityContextSource)this.appCtx.getBean("blah");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=ben,ou=people");
    }

    @Test
    public void loadingSpecificLdifFileIsSuccessful() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server ldif='classpath*:test-server2.xldif' root='dc=monkeymachine,dc=co,dc=uk' />");
        DefaultSpringSecurityContextSource contextSource = (DefaultSpringSecurityContextSource)this.appCtx.getBean("org.springframework.security.securityContextSource");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=pg,ou=gorillas");
    }
}

