/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import java.util.Collection;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.config.ldap.LdapUserServiceBeanDefinitionParser;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.InetOrgPerson;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.security.ldap.userdetails.Person;
import org.springframework.security.ldap.userdetails.PersonContextMapper;
import org.w3c.dom.Element;

public class LdapUserServiceBeanDefinitionParserTests {
    private InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void beanClassNamesAreCorrect() throws Exception {
        Assert.assertEquals((Object)"org.springframework.security.ldap.search.FilterBasedLdapUserSearch", (Object)FilterBasedLdapUserSearch.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.userdetails.PersonContextMapper", (Object)PersonContextMapper.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper", (Object)InetOrgPersonContextMapper.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.userdetails.LdapUserDetailsMapper", (Object)LdapUserDetailsMapper.class.getName());
        Assert.assertEquals((Object)"org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator", (Object)DefaultLdapAuthoritiesPopulator.class.getName());
        Assert.assertEquals((Object)LdapUserDetailsService.class.getName(), (Object)new LdapUserServiceBeanDefinitionParser().getBeanClassName((Element)Mockito.mock(Element.class)));
    }

    @Test
    public void minimalConfigurationIsParsedOk() throws Exception {
        this.setContext("<ldap-user-service user-search-filter='(uid={0})' /><ldap-server url='ldap://127.0.0.1:343/dc=springframework,dc=org' />");
    }

    @Test
    public void userServiceReturnsExpectedData() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Set authorities = AuthorityUtils.authorityListToSet((Collection)ben.getAuthorities());
        Assert.assertEquals((long)3L, (long)authorities.size());
        Assert.assertTrue((boolean)authorities.contains("ROLE_DEVELOPERS"));
    }

    @Test
    public void differentUserSearchBaseWorksAsExpected() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS'        user-search-base='ou=otherpeople'        user-search-filter='(cn={0})'        group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails joe = uds.loadUserByUsername("Joe Smeth");
        Assert.assertEquals((Object)"Joe Smeth", (Object)joe.getUsername());
    }

    @Test
    public void rolePrefixIsSupported() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS'      user-search-filter='(uid={0})'      group-search-filter='member={0}' role-prefix='PREFIX_'/><ldap-user-service id='ldapUDSNoPrefix'      user-search-filter='(uid={0})'      group-search-filter='member={0}' role-prefix='none'/><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)AuthorityUtils.authorityListToSet((Collection)ben.getAuthorities()).contains("PREFIX_DEVELOPERS"));
        uds = (UserDetailsService)this.appCtx.getBean("ldapUDSNoPrefix");
        ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)AuthorityUtils.authorityListToSet((Collection)ben.getAuthorities()).contains("DEVELOPERS"));
    }

    @Test
    public void differentGroupRoleAttributeWorksAsExpected() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' group-role-attribute='ou' group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Set authorities = AuthorityUtils.authorityListToSet((Collection)ben.getAuthorities());
        Assert.assertEquals((long)3L, (long)authorities.size());
        Assert.assertTrue((boolean)authorities.contains(new GrantedAuthorityImpl("ROLE_DEVELOPER")));
    }

    @Test
    public void isSupportedByAuthenticationProviderElement() {
        this.setContext("<ldap-server url='ldap://127.0.0.1:343/dc=springframework,dc=org'/><authentication-manager>  <authentication-provider>    <ldap-user-service user-search-filter='(uid={0})' />  </authentication-provider></authentication-manager>");
    }

    @Test
    public void personContextMapperIsSupported() {
        this.setContext("<ldap-server /><ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' user-details-class='person'/>");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)(ben instanceof Person));
    }

    @Test
    public void inetOrgContextMapperIsSupported() {
        this.setContext("<ldap-server id='someServer'/><ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' user-details-class='inetOrgPerson'/>");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)(ben instanceof InetOrgPerson));
    }

    @Test
    public void externalContextMapperIsSupported() {
        this.setContext("<ldap-server id='someServer'/><ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' user-context-mapper-ref='mapper'/><b:bean id='mapper' class='" + InetOrgPersonContextMapper.class.getName() + "'/>");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)(ben instanceof InetOrgPerson));
    }

    private void setContext(String context) {
        this.appCtx = new InMemoryXmlApplicationContext(context);
    }
}

