/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.BusinessService;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.intercept.RunAsManagerImpl;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.PostProcessedMockUserDetailsService;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.util.FieldUtils;

public class GlobalMethodSecurityBeanDefinitionParserTests {
    private final UsernamePasswordAuthenticationToken bob = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
    private AbstractXmlApplicationContext appContext;
    private BusinessService target;

    public void loadContext() {
        this.setContext("<b:bean id='target' class='org.springframework.security.access.annotation.BusinessServiceImpl'/><global-method-security order='1001' proxy-target-class='false' >    <protect-pointcut expression='execution(* *.someUser*(..))' access='ROLE_USER'/>    <protect-pointcut expression='execution(* *.someAdmin*(..))' access='ROLE_ADMIN'/></global-method-security><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.target = (BusinessService)this.appContext.getBean("target");
    }

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
        SecurityContextHolder.clearContext();
        this.target = null;
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void targetShouldPreventProtectedMethodInvocationWithNoContext() {
        this.loadContext();
        this.target.someUserMethod1();
    }

    @Test
    public void targetShouldAllowProtectedMethodInvocationWithCorrectRole() {
        this.loadContext();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someUserMethod1();
        Advisor[] advisors = ((Advised)this.target).getAdvisors();
        Assert.assertEquals((long)1L, (long)advisors.length);
        Assert.assertEquals((long)1001L, (long)((MethodSecurityMetadataSourceAdvisor)advisors[0]).getOrder());
    }

    @Test(expected=AccessDeniedException.class)
    public void targetShouldPreventProtectedMethodInvocationWithIncorrectRole() {
        this.loadContext();
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new String[]{"ROLE_SOMEOTHERROLE"});
        token.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someAdminMethod();
    }

    @Test
    public void doesntInterfereWithBeanPostProcessing() {
        this.setContext("<b:bean id='myUserService' class='org.springframework.security.config.PostProcessedMockUserDetailsService'/><global-method-security /><authentication-manager>   <authentication-provider user-service-ref='myUserService'/></authentication-manager><b:bean id='beanPostProcessor' class='org.springframework.security.config.MockUserServiceBeanPostProcessor'/>");
        PostProcessedMockUserDetailsService service = (PostProcessedMockUserDetailsService)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)"Hello from the post processor!", (Object)service.getPostProcessorWasHere());
    }

    @Test(expected=AccessDeniedException.class)
    public void worksWithAspectJAutoproxy() {
        this.setContext("<global-method-security>  <protect-pointcut expression='execution(* org.springframework.security.config.*Service.*(..))'       access='ROLE_SOMETHING' /></global-method-security><b:bean id='myUserService' class='org.springframework.security.config.PostProcessedMockUserDetailsService'/><aop:aspectj-autoproxy /><authentication-manager>   <authentication-provider user-service-ref='myUserService'/></authentication-manager>");
        UserDetailsService service = (UserDetailsService)this.appContext.getBean("myUserService");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_SOMEOTHERROLE"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        service.loadUserByUsername("notused");
    }

    @Test
    public void supportsMethodArgumentsInPointcut() {
        this.setContext("<b:bean id='target' class='org.springframework.security.access.annotation.BusinessServiceImpl'/><global-method-security>   <protect-pointcut expression='execution(* org.springframework.security.access.annotation.BusinessService.someOther(String))' access='ROLE_ADMIN'/>   <protect-pointcut expression='execution(* org.springframework.security.access.annotation.BusinessService.*(..))' access='ROLE_USER'/></global-method-security><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        this.target = (BusinessService)this.appContext.getBean("target");
        this.target.someOther(0);
        try {
            this.target.someOther("somestring");
            Assert.fail((String)"Expected AccessDeniedException");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void supportsBooleanPointcutExpressions() {
        this.setContext("<b:bean id='target' class='org.springframework.security.access.annotation.BusinessServiceImpl'/><global-method-security>   <protect-pointcut expression=     'execution(* org.springframework.security.access.annotation.BusinessService.*(..))        and not execution(* org.springframework.security.access.annotation.BusinessService.someOther(String)))'                access='ROLE_USER'/></global-method-security><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.target = (BusinessService)this.appContext.getBean("target");
        this.target.someOther("somestring");
        try {
            this.target.someOther(0);
            Assert.fail((String)"Expected AuthenticationCredentialsNotFoundException");
        }
        catch (AuthenticationCredentialsNotFoundException authenticationCredentialsNotFoundException) {
            // empty catch block
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        this.target.someOther(0);
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void duplicateElementCausesError() {
        this.setContext("<global-method-security /><global-method-security />");
    }

    @Test(expected=AccessDeniedException.class)
    public void worksWithoutTargetOrClass() {
        this.setContext("<global-method-security secured-annotations='enabled'/><b:bean id='businessService' class='org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean'>    <b:property name='serviceUrl' value='http://localhost:8080/SomeService'/>    <b:property name='serviceInterface' value='org.springframework.security.access.annotation.BusinessService'/></b:bean><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_SOMEOTHERROLE"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target = (BusinessService)this.appContext.getBean("businessService");
        this.target.someUserMethod1();
    }

    @Test
    public void expressionVoterAndAfterInvocationProviderUseSameExpressionHandlerInstance() throws Exception {
        this.setContext("<global-method-security pre-post-annotations='enabled'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        AffirmativeBased adm = (AffirmativeBased)this.appContext.getBeansOfType(AffirmativeBased.class).values().toArray()[0];
        List voters = (List)FieldUtils.getFieldValue((Object)adm, (String)"decisionVoters");
        PreInvocationAuthorizationAdviceVoter mev = (PreInvocationAuthorizationAdviceVoter)voters.get(0);
        MethodSecurityMetadataSourceAdvisor msi = (MethodSecurityMetadataSourceAdvisor)this.appContext.getBeansOfType(MethodSecurityMetadataSourceAdvisor.class).values().toArray()[0];
        AfterInvocationProviderManager pm = (AfterInvocationProviderManager)((MethodSecurityInterceptor)msi.getAdvice()).getAfterInvocationManager();
        PostInvocationAdviceProvider aip = (PostInvocationAdviceProvider)pm.getProviders().get(0);
        Assert.assertTrue((FieldUtils.getFieldValue((Object)mev, (String)"preAdvice.expressionHandler") == FieldUtils.getFieldValue((Object)aip, (String)"postAdvice.expressionHandler") ? 1 : 0) != 0);
    }

    @Test(expected=AccessDeniedException.class)
    public void accessIsDeniedForHasRoleExpression() {
        this.setContext("<global-method-security pre-post-annotations='enabled'/><b:bean id='target' class='org.springframework.security.access.annotation.ExpressionProtectedBusinessServiceImpl'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.bob);
        this.target = (BusinessService)this.appContext.getBean("target");
        this.target.someAdminMethod();
    }

    @Test
    public void preAndPostFilterAnnotationsWorkWithLists() {
        this.setContext("<global-method-security pre-post-annotations='enabled'/><b:bean id='target' class='org.springframework.security.access.annotation.ExpressionProtectedBusinessServiceImpl'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.bob);
        this.target = (BusinessService)this.appContext.getBean("target");
        ArrayList<String> arg = new ArrayList<String>();
        arg.add("joe");
        arg.add("bob");
        arg.add("sam");
        List result = this.target.methodReturningAList(arg);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"bob", result.get(0));
    }

    @Test
    public void prePostFilterAnnotationWorksWithArrays() {
        this.setContext("<global-method-security pre-post-annotations='enabled'/><b:bean id='target' class='org.springframework.security.access.annotation.ExpressionProtectedBusinessServiceImpl'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.bob);
        this.target = (BusinessService)this.appContext.getBean("target");
        Object[] arg = new String[]{"joe", "bob", "sam"};
        Object[] result = this.target.methodReturningAnArray(arg);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"bob", (Object)result[0]);
    }

    @Test
    public void customPermissionEvaluatorIsSupported() throws Exception {
        this.setContext("<global-method-security pre-post-annotations='enabled'>   <expression-handler ref='expressionHandler'/></global-method-security><b:bean id='expressionHandler' class='org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler'>   <b:property name='permissionEvaluator' ref='myPermissionEvaluator'/></b:bean><b:bean id='myPermissionEvaluator' class='org.springframework.security.config.method.TestPermissionEvaluator'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
    }

    @Test(expected=AuthenticationException.class)
    public void genericsAreMatchedByProtectPointcut() throws Exception {
        this.setContext("<b:bean id='target' class='org.springframework.security.config.method.GlobalMethodSecurityBeanDefinitionParserTests$ConcreteFoo'/><global-method-security>   <protect-pointcut expression='execution(* org..*Foo.foo(..))' access='ROLE_USER'/></global-method-security><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        Foo foo = (Foo)this.appContext.getBean("target");
        foo.foo(new SecurityConfig("A"));
    }

    @Test
    public void genericsMethodArgumentNamesAreResolved() throws Exception {
        this.setContext("<b:bean id='target' class='" + ConcreteFoo.class.getName() + "'/>" + "<global-method-security pre-post-annotations='enabled'/>" + "<authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.bob);
        Foo foo = (Foo)this.appContext.getBean("target");
        foo.foo(new SecurityConfig("A"));
    }

    @Test
    public void runAsManagerIsSetCorrectly() throws Exception {
        StaticApplicationContext parent = new StaticApplicationContext();
        MutablePropertyValues props = new MutablePropertyValues();
        props.addPropertyValue("key", (Object)"blah");
        parent.registerSingleton("runAsMgr", RunAsManagerImpl.class, props);
        parent.refresh();
        this.setContext("<global-method-security run-as-manager-ref='runAsMgr'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>", (ApplicationContext)parent);
        RunAsManagerImpl ram = (RunAsManagerImpl)this.appContext.getBean("runAsMgr");
        MethodSecurityMetadataSourceAdvisor msi = (MethodSecurityMetadataSourceAdvisor)this.appContext.getBeansOfType(MethodSecurityMetadataSourceAdvisor.class).values().toArray()[0];
        Assert.assertSame((Object)ram, (Object)FieldUtils.getFieldValue((Object)msi.getAdvice(), (String)"runAsManager"));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    private void setContext(String context, ApplicationContext parent) {
        this.appContext = new InMemoryXmlApplicationContext(context, parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConcreteFoo
    implements Foo<SecurityConfig> {
        @Override
        @PreAuthorize(value="#action.attribute == 'A'")
        public void foo(SecurityConfig action) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Foo<T extends ConfigAttribute> {
        public void foo(T var1);
    }
}

