/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.config.TestBusinessBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class InterceptMethodsBeanDefinitionDecoratorTests {
    private ClassPathXmlApplicationContext appContext;
    private TestBusinessBean target;

    @Before
    public void loadContext() {
        System.setProperty("admin.role", "ROLE_ADMIN");
        this.appContext = new ClassPathXmlApplicationContext("org/springframework/security/config/method-security.xml");
        this.target = (TestBusinessBean)this.appContext.getBean("target");
    }

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
        SecurityContextHolder.clearContext();
    }

    @Test
    public void targetDoesntLoseApplicationListenerInterface() {
        Assert.assertEquals((long)1L, (long)this.appContext.getBeansOfType(ApplicationListener.class).size());
        Assert.assertEquals((long)1L, (long)this.appContext.getBeanNamesForType(ApplicationListener.class).length);
        this.appContext.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent((Authentication)new TestingAuthenticationToken((Object)"user", (Object)"")));
        Assert.assertTrue((boolean)(this.target instanceof ApplicationListener));
    }

    @Test
    public void targetShouldAllowUnprotectedMethodInvocationWithNoContext() {
        this.target.unprotected();
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void targetShouldPreventProtectedMethodInvocationWithNoContext() {
        this.target.doSomething();
    }

    @Test
    public void targetShouldAllowProtectedMethodInvocationWithCorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.doSomething();
    }

    @Test(expected=AccessDeniedException.class)
    public void targetShouldPreventProtectedMethodInvocationWithIncorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_SOMEOTHERROLE"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.doSomething();
        Assert.fail((String)"Expected AccessDeniedException");
    }
}

