/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.annotation.BusinessService;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class Jsr250AnnotationDrivenBeanDefinitionParserTests {
    private InMemoryXmlApplicationContext appContext;
    private BusinessService target;

    @Before
    public void loadContext() {
        this.appContext = new InMemoryXmlApplicationContext("<b:bean id='target' class='org.springframework.security.access.annotation.Jsr250BusinessServiceImpl'/><global-method-security jsr250-annotations='enabled'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.target = (BusinessService)this.appContext.getBean("target");
    }

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
        SecurityContextHolder.clearContext();
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void targetShouldPreventProtectedMethodInvocationWithNoContext() {
        this.target.someUserMethod1();
    }

    @Test
    public void permitAllShouldBeDefaultAttribute() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someOther(0);
    }

    @Test
    public void targetShouldAllowProtectedMethodInvocationWithCorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someUserMethod1();
    }

    @Test(expected=AccessDeniedException.class)
    public void targetShouldPreventProtectedMethodInvocationWithIncorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_SOMEOTHERROLE"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someAdminMethod();
    }
}

