/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.annotation.BusinessService;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecuredAnnotationDrivenBeanDefinitionParserTests {
    private InMemoryXmlApplicationContext appContext;
    private BusinessService target;

    @Before
    public void loadContext() {
        SecurityContextHolder.clearContext();
        this.appContext = new InMemoryXmlApplicationContext("<b:bean id='target' class='org.springframework.security.access.annotation.BusinessServiceImpl'/><global-method-security secured-annotations='enabled'/><authentication-manager alias='authManager'>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>");
        this.target = (BusinessService)this.appContext.getBean("target");
    }

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
        SecurityContextHolder.clearContext();
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void targetShouldPreventProtectedMethodInvocationWithNoContext() {
        this.target.someUserMethod1();
    }

    @Test
    public void targetShouldAllowProtectedMethodInvocationWithCorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someUserMethod1();
    }

    @Test(expected=AccessDeniedException.class)
    public void targetShouldPreventProtectedMethodInvocationWithIncorrectRole() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_SOMEOTHER"}));
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.target.someAdminMethod();
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void targetIsSerializableBeforeUse() throws Exception {
        BusinessService chompedTarget = (BusinessService)this.serializeAndDeserialize(this.target);
        chompedTarget.someAdminMethod();
    }

    @Test(expected=AccessDeniedException.class)
    public void targetIsSerializableAfterUse() throws Exception {
        try {
            this.target.someAdminMethod();
        }
        catch (AuthenticationCredentialsNotFoundException expected) {
            // empty catch block
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"u", (Object)"p", new String[]{"ROLE_A"}));
        BusinessService chompedTarget = (BusinessService)this.serializeAndDeserialize(this.target);
        chompedTarget.someAdminMethod();
    }

    private Object serializeAndDeserialize(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.flush();
        baos.flush();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(is);
        Object o2 = ois.readObject();
        return o2;
    }
}

