/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aopalliance;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.ITargetObject;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.config.util.InMemoryXmlApplicationContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class MethodSecurityInterceptorWithAopConfigTests {
    static final String AUTH_PROVIDER_XML = "<authentication-manager>    <authentication-provider>        <user-service>            <user name='bob' password='bobspassword' authorities='ROLE_USER,ROLE_ADMIN' />            <user name='bill' password='billspassword' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager>";
    static final String ACCESS_MANAGER_XML = "<b:bean id='accessDecisionManager' class='org.springframework.security.access.vote.AffirmativeBased'>   <b:property name='decisionVoters'>       <b:list><b:bean class='org.springframework.security.access.vote.RoleVoter'/></b:list>   </b:property></b:bean>";
    static final String TARGET_BEAN_AND_INTERCEPTOR = "<b:bean id='target' class='org.springframework.security.TargetObject'/><b:bean id='securityInterceptor' class='org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor' autowire='byType' >     <b:property name='securityMetadataSource'>       <b:value>org.springframework.security.ITargetObject.makeLower*=ROLE_A\norg.springframework.security.TargetObject.makeUpper*=ROLE_A\norg.springframework.security.ITargetObject.computeHashCode*=ROLE_B\n       </b:value>     </b:property></b:bean>";
    private AbstractXmlApplicationContext appContext;

    @Before
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @After
    public void closeAppContext() {
        SecurityContextHolder.clearContext();
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void securityInterceptorIsAppliedWhenUsedWithAopConfig() {
        this.setContext("<aop:config>     <aop:pointcut id='targetMethods' expression='execution(* org.springframework.security.TargetObject.*(..))'/>     <aop:advisor advice-ref='securityInterceptor' pointcut-ref='targetMethods' /></aop:config><b:bean id='target' class='org.springframework.security.TargetObject'/><b:bean id='securityInterceptor' class='org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor' autowire='byType' >     <b:property name='securityMetadataSource'>       <b:value>org.springframework.security.ITargetObject.makeLower*=ROLE_A\norg.springframework.security.TargetObject.makeUpper*=ROLE_A\norg.springframework.security.ITargetObject.computeHashCode*=ROLE_B\n       </b:value>     </b:property></b:bean><authentication-manager>    <authentication-provider>        <user-service>            <user name='bob' password='bobspassword' authorities='ROLE_USER,ROLE_ADMIN' />            <user name='bill' password='billspassword' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager><b:bean id='accessDecisionManager' class='org.springframework.security.access.vote.AffirmativeBased'>   <b:property name='decisionVoters'>       <b:list><b:bean class='org.springframework.security.access.vote.RoleVoter'/></b:list>   </b:property></b:bean>");
        ITargetObject target = (ITargetObject)this.appContext.getBean("target");
        try {
            target.makeLowerCase("TEST");
            Assert.fail((String)"AuthenticationCredentialsNotFoundException expected");
        }
        catch (AuthenticationCredentialsNotFoundException authenticationCredentialsNotFoundException) {
            // empty catch block
        }
        target.makeUpperCase("test");
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void securityInterceptorIsAppliedWhenUsedWithBeanNameAutoProxyCreator() {
        this.setContext("<b:bean id='autoProxyCreator' class='org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator'>   <b:property name='interceptorNames'>       <b:list>          <b:value>securityInterceptor</b:value>       </b:list>   </b:property>   <b:property name='beanNames'>       <b:list>          <b:value>target</b:value>       </b:list>   </b:property>   <b:property name='proxyTargetClass' value='false'/></b:bean><b:bean id='target' class='org.springframework.security.TargetObject'/><b:bean id='securityInterceptor' class='org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor' autowire='byType' >     <b:property name='securityMetadataSource'>       <b:value>org.springframework.security.ITargetObject.makeLower*=ROLE_A\norg.springframework.security.TargetObject.makeUpper*=ROLE_A\norg.springframework.security.ITargetObject.computeHashCode*=ROLE_B\n       </b:value>     </b:property></b:bean><authentication-manager>    <authentication-provider>        <user-service>            <user name='bob' password='bobspassword' authorities='ROLE_USER,ROLE_ADMIN' />            <user name='bill' password='billspassword' authorities='ROLE_USER' />        </user-service>    </authentication-provider></authentication-manager><b:bean id='accessDecisionManager' class='org.springframework.security.access.vote.AffirmativeBased'>   <b:property name='decisionVoters'>       <b:list><b:bean class='org.springframework.security.access.vote.RoleVoter'/></b:list>   </b:property></b:bean>");
        ITargetObject target = (ITargetObject)this.appContext.getBean("target");
        try {
            target.makeLowerCase("TEST");
            Assert.fail((String)"AuthenticationCredentialsNotFoundException expected");
        }
        catch (AuthenticationCredentialsNotFoundException authenticationCredentialsNotFoundException) {
            // empty catch block
        }
        target.makeUpperCase("test");
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

