/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.openid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.openid.AxFetchListFactory;
import org.springframework.security.openid.OpenID4JavaConsumer;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationFilter;
import org.springframework.security.openid.OpenIDAuthenticationProvider;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.RegexBasedAxFetchListFactory;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenIDLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, OpenIDLoginConfigurer<H>, OpenIDAuthenticationFilter> {
    private OpenIDConsumer openIDConsumer;
    private ConsumerManager consumerManager;
    private AuthenticationUserDetailsService<OpenIDAuthenticationToken> authenticationUserDetailsService;
    private List<AttributeExchangeConfigurer> attributeExchangeConfigurers = new ArrayList<AttributeExchangeConfigurer>();

    public OpenIDLoginConfigurer() {
        super(new OpenIDAuthenticationFilter(), "/login/openid");
    }

    public AttributeExchangeConfigurer attributeExchange(String identifierPattern) {
        AttributeExchangeConfigurer attributeExchangeConfigurer = new AttributeExchangeConfigurer(identifierPattern);
        this.attributeExchangeConfigurers.add(attributeExchangeConfigurer);
        return attributeExchangeConfigurer;
    }

    public OpenIDLoginConfigurer<H> consumer(OpenIDConsumer consumer) {
        this.openIDConsumer = consumer;
        return this;
    }

    public OpenIDLoginConfigurer<H> consumerManager(ConsumerManager consumerManager) {
        this.consumerManager = consumerManager;
        return this;
    }

    public OpenIDLoginConfigurer<H> authenticationUserDetailsService(AuthenticationUserDetailsService<OpenIDAuthenticationToken> authenticationUserDetailsService) {
        this.authenticationUserDetailsService = authenticationUserDetailsService;
        return this;
    }

    @Override
    public OpenIDLoginConfigurer<H> loginProcessingUrl(String loginProcessingUrl) {
        return (OpenIDLoginConfigurer)super.loginProcessingUrl(loginProcessingUrl);
    }

    @Override
    public OpenIDLoginConfigurer<H> loginPage(String loginPage) {
        return (OpenIDLoginConfigurer)super.loginPage(loginPage);
    }

    @Override
    public void init(H http) throws Exception {
        super.init(http);
        OpenIDAuthenticationProvider authenticationProvider = new OpenIDAuthenticationProvider();
        authenticationProvider.setAuthenticationUserDetailsService(this.getAuthenticationUserDetailsService(http));
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider);
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(H http) throws Exception {
        ((OpenIDAuthenticationFilter)this.getAuthenticationFilter()).setConsumer(this.getConsumer());
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    private OpenIDConsumer getConsumer() throws ConsumerException {
        if (this.openIDConsumer == null) {
            this.openIDConsumer = new OpenID4JavaConsumer(this.getConsumerManager(), this.attributesToFetchFactory());
        }
        return this.openIDConsumer;
    }

    private ConsumerManager getConsumerManager() {
        if (this.consumerManager != null) {
            return this.consumerManager;
        }
        return new ConsumerManager();
    }

    private AxFetchListFactory attributesToFetchFactory() {
        HashMap<String, List> identityToAttrs = new HashMap<String, List>();
        for (AttributeExchangeConfigurer conf : this.attributeExchangeConfigurers) {
            identityToAttrs.put(conf.identifier, conf.getAttributes());
        }
        return new RegexBasedAxFetchListFactory(identityToAttrs);
    }

    private AuthenticationUserDetailsService<OpenIDAuthenticationToken> getAuthenticationUserDetailsService(H http) {
        if (this.authenticationUserDetailsService != null) {
            return this.authenticationUserDetailsService;
        }
        return new UserDetailsByNameServiceWrapper(http.getSharedObject(UserDetailsService.class));
    }

    private void initDefaultLoginFilter(H http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null && !this.isCustomLoginPage()) {
            loginPageGeneratingFilter.setOpenIdEnabled(true);
            loginPageGeneratingFilter.setOpenIDauthenticationUrl(this.getLoginProcessingUrl());
            String loginPageUrl = loginPageGeneratingFilter.getLoginPageUrl();
            if (loginPageUrl == null) {
                loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
                loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
            }
            loginPageGeneratingFilter.setOpenIDusernameParameter("openid_identifier");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AttributeExchangeConfigurer {
        private final String identifier;
        private List<OpenIDAttribute> attributes = new ArrayList<OpenIDAttribute>();
        private List<org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer> attributeConfigurers = new ArrayList<org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer>();

        private AttributeExchangeConfigurer(String identifierPattern) {
            this.identifier = identifierPattern;
        }

        public OpenIDLoginConfigurer<H> and() {
            return OpenIDLoginConfigurer.this;
        }

        public AttributeExchangeConfigurer attribute(OpenIDAttribute attribute) {
            this.attributes.add(attribute);
            return this;
        }

        public org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer attribute(String name) {
            AttributeConfigurer attributeConfigurer = new AttributeConfigurer(name);
            this.attributeConfigurers.add((org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer)attributeConfigurer);
            return attributeConfigurer;
        }

        private List<OpenIDAttribute> getAttributes() {
            for (AttributeConfigurer attributeConfigurer : this.attributeConfigurers) {
                this.attributes.add(attributeConfigurer.build());
            }
            this.attributeConfigurers.clear();
            return this.attributes;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class AttributeConfigurer {
            private String name;
            private int count = 1;
            private boolean required = false;
            private String type;

            private AttributeConfigurer(String name) {
                this.name = name;
            }

            public org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer count(int count) {
                this.count = count;
                return this;
            }

            public org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer required(boolean required) {
                this.required = required;
                return this;
            }

            public org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer$AttributeExchangeConfigurer.AttributeConfigurer type(String type) {
                this.type = type;
                return this;
            }

            public AttributeExchangeConfigurer and() {
                return AttributeExchangeConfigurer.this;
            }

            private OpenIDAttribute build() {
                OpenIDAttribute attribute = new OpenIDAttribute(this.name, this.type);
                attribute.setCount(this.count);
                attribute.setRequired(this.required);
                return attribute;
            }
        }
    }
}

