/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.RequestMatcherFactory;
import org.springframework.security.config.annotation.web.ServletRegistrationsSupport;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent;
    private static final RequestMatcher ANY_REQUEST;
    private ApplicationContext context;
    private boolean anyRequestConfigured = false;
    private final Log logger = LogFactory.getLog(this.getClass());

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure anyRequest after itself");
        C configurer = this.requestMatchers(ANY_REQUEST);
        this.anyRequestConfigured = true;
        return configurer;
    }

    protected final List<MvcRequestMatcher> createMvcMatchers(HttpMethod method, String ... mvcPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure mvcMatchers after anyRequest");
        ResolvableType type = ResolvableType.forClassWithGenerics(ObjectPostProcessor.class, (Class[])new Class[]{Object.class});
        ObjectProvider postProcessors = this.context.getBeanProvider(type);
        ObjectPostProcessor opp = (ObjectPostProcessor)postProcessors.getObject();
        if (!this.context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)this.context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<MvcRequestMatcher> matchers = new ArrayList<MvcRequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            opp.postProcess(matcher);
            if (method != null) {
                matcher.setMethod(method);
            }
            matchers.add(matcher);
        }
        return matchers;
    }

    public C dispatcherTypeMatchers(@Nullable HttpMethod method, DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (DispatcherType dispatcherType : dispatcherTypes) {
            matchers.add((RequestMatcher)new DispatcherTypeRequestMatcher(dispatcherType, method));
        }
        return this.chainRequestMatchers(matchers);
    }

    public C dispatcherTypeMatchers(DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        return this.dispatcherTypeMatchers((HttpMethod)null, dispatcherTypes);
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    public C requestMatchers(HttpMethod method, String ... patterns) {
        if (this.anyPathsDontStartWithLeadingSlash(patterns)) {
            this.logger.warn((Object)("One of the patterns in " + Arrays.toString(patterns) + " is missing a leading slash. This is discouraged; please include the leading slash in all your request matcher patterns. In future versions of Spring Security, leaving out the leading slash will result in an exception."));
        }
        if (!mvcPresent) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        if (!(this.context instanceof WebApplicationContext)) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        WebApplicationContext context = (WebApplicationContext)this.context;
        ServletContext servletContext = context.getServletContext();
        if (servletContext == null) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (String pattern : patterns) {
            if (RequestMatcherFactory.usesPathPatterns()) {
                matchers.add(RequestMatcherFactory.matcher(method, pattern));
                continue;
            }
            AntPathRequestMatcher ant = new AntPathRequestMatcher(pattern, method != null ? method.name() : null);
            MvcRequestMatcher mvc = this.createMvcMatchers(method, pattern).get(0);
            matchers.add(new DeferredRequestMatcher(c -> this.resolve(ant, mvc, (ServletContext)c), new RequestMatcher[]{mvc, ant}));
        }
        return this.requestMatchers(matchers.toArray(new RequestMatcher[0]));
    }

    private boolean anyPathsDontStartWithLeadingSlash(String ... patterns) {
        for (String pattern : patterns) {
            if (pattern.startsWith("/")) continue;
            return true;
        }
        return false;
    }

    private RequestMatcher resolve(AntPathRequestMatcher ant, MvcRequestMatcher mvc, ServletContext servletContext) {
        ServletRegistrationsSupport registrations = new ServletRegistrationsSupport(servletContext);
        Collection<ServletRegistrationsSupport.RegistrationMapping> mappings = registrations.mappings();
        if (mappings.isEmpty()) {
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc, new MockMvcRequestMatcher());
        }
        Collection<ServletRegistrationsSupport.RegistrationMapping> dispatcherServletMappings = registrations.dispatcherServletMappings();
        if (dispatcherServletMappings.isEmpty()) {
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc, new MockMvcRequestMatcher());
        }
        if (dispatcherServletMappings.size() > 1) {
            String errorMessage = AbstractRequestMatcherRegistry.computeErrorMessage(servletContext.getServletRegistrations().values());
            throw new IllegalArgumentException(errorMessage);
        }
        ServletRegistrationsSupport.RegistrationMapping dispatcherServlet = dispatcherServletMappings.iterator().next();
        if (mappings.size() > 1 && !dispatcherServlet.isDefault()) {
            String errorMessage = AbstractRequestMatcherRegistry.computeErrorMessage(servletContext.getServletRegistrations().values());
            throw new IllegalArgumentException(errorMessage);
        }
        if (dispatcherServlet.isDefault()) {
            if (mappings.size() == 1) {
                return mvc;
            }
            return new DispatcherServletDelegatingRequestMatcher(ant, mvc);
        }
        return mvc;
    }

    private static String computeErrorMessage(Collection<? extends ServletRegistration> registrations) {
        String template = "This method cannot decide whether these patterns are Spring MVC patterns or not. This is because there is more than one mappable servlet in your servlet context: %s.\n\nTo address this, please create one PathPatternRequestMatcher.Builder#servletPath for each servlet that has authorized endpoints and use them to construct request matchers manually.\n";
        LinkedHashMap<String, Collection> mappings = new LinkedHashMap<String, Collection>();
        for (ServletRegistration servletRegistration : registrations) {
            mappings.put(servletRegistration.getClassName(), servletRegistration.getMappings());
        }
        return String.format(template, mappings);
    }

    public C requestMatchers(String ... patterns) {
        return this.requestMatchers((HttpMethod)null, patterns);
    }

    public C requestMatchers(HttpMethod method) {
        return this.requestMatchers(method, "/**");
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    static {
        ANY_REQUEST = AnyRequestMatcher.INSTANCE;
        mvcPresent = ClassUtils.isPresent((String)HANDLER_MAPPING_INTROSPECTOR, (ClassLoader)AbstractRequestMatcherRegistry.class.getClassLoader());
    }

    private static final class RequestMatchers {
        private RequestMatchers() {
        }

        static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            return Arrays.asList(RequestMatchers.antMatchersAsArray(httpMethod, antPatterns));
        }

        static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        static RequestMatcher[] antMatchersAsArray(HttpMethod httpMethod, String ... antPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            RequestMatcher[] matchers = new RequestMatcher[antPatterns.length];
            for (int index = 0; index < antPatterns.length; ++index) {
                matchers[index] = new AntPathRequestMatcher(antPatterns[index], method);
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add((RequestMatcher)new RegexRequestMatcher(pattern, method));
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }
    }

    static class DeferredRequestMatcher
    implements RequestMatcher {
        final Function<ServletContext, RequestMatcher> requestMatcherFactory;
        final AtomicReference<String> description = new AtomicReference();
        final Map<ServletContext, RequestMatcher> requestMatchers = new ConcurrentHashMap<ServletContext, RequestMatcher>();

        DeferredRequestMatcher(Function<ServletContext, RequestMatcher> resolver, RequestMatcher ... candidates) {
            this.requestMatcherFactory = sc -> this.requestMatchers.computeIfAbsent((ServletContext)sc, resolver);
            this.description.set("Deferred " + Arrays.toString(candidates));
        }

        RequestMatcher requestMatcher(ServletContext servletContext) {
            return this.requestMatcherFactory.apply(servletContext);
        }

        public boolean matches(HttpServletRequest request) {
            return this.requestMatcherFactory.apply(request.getServletContext()).matches(request);
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.requestMatcherFactory.apply(request.getServletContext()).matcher(request);
        }

        public String toString() {
            return this.description.get();
        }
    }

    static class DispatcherServletDelegatingRequestMatcher
    implements RequestMatcher {
        private final AntPathRequestMatcher ant;
        private final MvcRequestMatcher mvc;
        private final RequestMatcher dispatcherServlet;

        DispatcherServletDelegatingRequestMatcher(AntPathRequestMatcher ant, MvcRequestMatcher mvc) {
            this(ant, mvc, (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new MockMvcRequestMatcher(), new DispatcherServletRequestMatcher()}));
        }

        DispatcherServletDelegatingRequestMatcher(AntPathRequestMatcher ant, MvcRequestMatcher mvc, RequestMatcher dispatcherServlet) {
            this.ant = ant;
            this.mvc = mvc;
            this.dispatcherServlet = dispatcherServlet;
        }

        RequestMatcher requestMatcher(HttpServletRequest request) {
            if (this.dispatcherServlet.matches(request)) {
                return this.mvc;
            }
            return this.ant;
        }

        public boolean matches(HttpServletRequest request) {
            return this.requestMatcher(request).matches(request);
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.requestMatcher(request).matcher(request);
        }

        public String toString() {
            return "DispatcherServletDelegating [ant = " + String.valueOf(this.ant) + ", mvc = " + String.valueOf(this.mvc) + "]";
        }
    }

    static class MockMvcRequestMatcher
    implements RequestMatcher {
        MockMvcRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            return request.getAttribute("org.springframework.test.web.servlet.MockMvc.MVC_RESULT_ATTRIBUTE") != null;
        }
    }

    static class DispatcherServletRequestMatcher
    implements RequestMatcher {
        DispatcherServletRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            String name = request.getHttpServletMapping().getServletName();
            ServletRegistration registration = request.getServletContext().getServletRegistration(name);
            Assert.notNull((Object)registration, () -> AbstractRequestMatcherRegistry.computeErrorMessage(request.getServletContext().getServletRegistrations().values()));
            try {
                Class<?> clazz = Class.forName(registration.getClassName());
                return DispatcherServlet.class.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }
}

