/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.SingleResultAuthorizationManager;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.builders.WebSecurityFilterChainValidator;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.PathPatternRequestTransformer;
import org.springframework.security.web.access.RequestMatcherDelegatingWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.expression.DefaultHttpSecurityExpressionHandler;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.debug.DebugFilter;
import org.springframework.security.web.firewall.CompositeRequestRejectedHandler;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.HttpStatusRequestRejectedHandler;
import org.springframework.security.web.firewall.ObservationMarkingRequestRejectedHandler;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;

public final class WebSecurity
extends AbstractConfiguredSecurityBuilder<Filter, WebSecurity>
implements SecurityBuilder<Filter>,
ApplicationContextAware,
ServletContextAware {
    private static final boolean USING_ACCESS = ClassUtils.isPresent((String)"org.springframework.security.access.SecurityConfig", null);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RequestMatcher> ignoredRequests = new ArrayList<RequestMatcher>();
    private final List<SecurityBuilder<? extends SecurityFilterChain>> securityFilterChainBuilders = new ArrayList<SecurityBuilder<? extends SecurityFilterChain>>();
    private IgnoredRequestConfigurer ignoredRequestRegistry;
    private HttpFirewall httpFirewall;
    private RequestRejectedHandler requestRejectedHandler;
    private boolean debugEnabled;
    private WebInvocationPrivilegeEvaluator privilegeEvaluator;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    private ObjectPostProcessor<FilterChainProxy.FilterChainDecorator> filterChainDecoratorPostProcessor = ObjectPostProcessor.identity();
    private AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer privilegeEvaluatorRequestTransformer;
    private DefaultHttpSecurityExpressionHandler defaultExpressionHandler = new DefaultHttpSecurityExpressionHandler();
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = new SecurityExpressionHandlerAdapter((AbstractSecurityExpressionHandler<RequestAuthorizationContext>)this.defaultExpressionHandler);
    private Runnable postBuildAction = () -> {};
    private ServletContext servletContext;

    public WebSecurity(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public IgnoredRequestConfigurer ignoring() {
        return this.ignoredRequestRegistry;
    }

    public WebSecurity httpFirewall(HttpFirewall httpFirewall) {
        this.httpFirewall = httpFirewall;
        return this;
    }

    public WebSecurity debug(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public WebSecurity addSecurityFilterChainBuilder(SecurityBuilder<? extends SecurityFilterChain> securityFilterChainBuilder) {
        this.securityFilterChainBuilders.add(securityFilterChainBuilder);
        return this;
    }

    public WebSecurity privilegeEvaluator(WebInvocationPrivilegeEvaluator privilegeEvaluator) {
        this.privilegeEvaluator = privilegeEvaluator;
        return this;
    }

    public WebSecurity expressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
        return this;
    }

    public SecurityExpressionHandler<FilterInvocation> getExpressionHandler() {
        return this.expressionHandler;
    }

    public WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() {
        return this.privilegeEvaluator;
    }

    public WebSecurity postBuildAction(Runnable postBuildAction) {
        this.postBuildAction = postBuildAction;
        return this;
    }

    public WebSecurity requestRejectedHandler(RequestRejectedHandler requestRejectedHandler) {
        Assert.notNull((Object)requestRejectedHandler, (String)"requestRejectedHandler cannot be null");
        this.requestRejectedHandler = requestRejectedHandler;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Filter performBuild() throws Exception {
        void var6_15;
        SecurityFilterChain securityFilterChain;
        Assert.state((!this.securityFilterChainBuilders.isEmpty() ? 1 : 0) != 0, () -> "At least one SecurityBuilder<? extends SecurityFilterChain> needs to be specified. Typically this is done by exposing a SecurityFilterChain bean. More advanced users can invoke " + WebSecurity.class.getSimpleName() + ".addSecurityFilterChainBuilder directly");
        int chainSize = this.ignoredRequests.size() + this.securityFilterChainBuilders.size();
        ArrayList<SecurityFilterChain> securityFilterChains = new ArrayList<SecurityFilterChain>(chainSize);
        RequestMatcherDelegatingAuthorizationManager.Builder builder = RequestMatcherDelegatingAuthorizationManager.builder();
        boolean mappings = false;
        for (RequestMatcher requestMatcher : this.ignoredRequests) {
            this.logger.warn((Object)("You are asking Spring Security to ignore " + String.valueOf(requestMatcher) + ". This is not recommended -- please use permitAll via HttpSecurity#authorizeHttpRequests instead."));
            securityFilterChain = new DefaultSecurityFilterChain(requestMatcher, new Filter[0]);
            securityFilterChains.add(securityFilterChain);
            builder.add(requestMatcher, (AuthorizationManager)SingleResultAuthorizationManager.permitAll());
            mappings = true;
        }
        for (SecurityBuilder securityBuilder : this.securityFilterChainBuilders) {
            securityFilterChain = (SecurityFilterChain)securityBuilder.build();
            securityFilterChains.add(securityFilterChain);
            mappings = this.addAuthorizationManager(securityFilterChain, builder) || mappings;
        }
        if (this.privilegeEvaluator == null) {
            SingleResultAuthorizationManager authorizationManager = mappings ? builder.build() : SingleResultAuthorizationManager.permitAll();
            AuthorizationManagerWebInvocationPrivilegeEvaluator authorizationManagerWebInvocationPrivilegeEvaluator = new AuthorizationManagerWebInvocationPrivilegeEvaluator((AuthorizationManager)authorizationManager);
            authorizationManagerWebInvocationPrivilegeEvaluator.setServletContext(this.servletContext);
            if (this.privilegeEvaluatorRequestTransformer != null) {
                authorizationManagerWebInvocationPrivilegeEvaluator.setRequestTransformer(this.privilegeEvaluatorRequestTransformer);
            }
            this.privilegeEvaluator = new RequestMatcherDelegatingWebInvocationPrivilegeEvaluator(List.of(new RequestMatcherEntry(AnyRequestMatcher.INSTANCE, List.of(authorizationManagerWebInvocationPrivilegeEvaluator))));
        }
        FilterChainProxy filterChainProxy = new FilterChainProxy(securityFilterChains);
        if (this.httpFirewall != null) {
            filterChainProxy.setFirewall(this.httpFirewall);
        }
        if (this.requestRejectedHandler != null) {
            filterChainProxy.setRequestRejectedHandler(this.requestRejectedHandler);
        } else if (!this.observationRegistry.isNoop()) {
            CompositeRequestRejectedHandler compositeRequestRejectedHandler = new CompositeRequestRejectedHandler(new RequestRejectedHandler[]{new ObservationMarkingRequestRejectedHandler(this.observationRegistry), new HttpStatusRequestRejectedHandler()});
            filterChainProxy.setRequestRejectedHandler((RequestRejectedHandler)compositeRequestRejectedHandler);
        }
        filterChainProxy.setFilterChainValidator((FilterChainProxy.FilterChainValidator)new WebSecurityFilterChainValidator());
        filterChainProxy.setFilterChainDecorator(this.getFilterChainDecorator());
        filterChainProxy.afterPropertiesSet();
        FilterChainProxy filterChainProxy2 = filterChainProxy;
        if (this.debugEnabled) {
            this.logger.warn((Object)"\n\n********************************************************************\n**********        Security debugging is enabled.       *************\n**********    This may include sensitive information.  *************\n**********      Do not use in a production system!     *************\n********************************************************************\n\n");
            DebugFilter debugFilter = new DebugFilter(filterChainProxy);
        }
        this.postBuildAction.run();
        return var6_15;
    }

    private boolean addAuthorizationManager(SecurityFilterChain securityFilterChain, RequestMatcherDelegatingAuthorizationManager.Builder builder) {
        boolean mappings = false;
        for (Filter filter : securityFilterChain.getFilters()) {
            if (USING_ACCESS) {
                mappings = AccessComponents.addAuthorizationManager(filter, this.servletContext, builder, securityFilterChain);
            }
            if (!(filter instanceof AuthorizationFilter)) continue;
            AuthorizationFilter authorization = (AuthorizationFilter)filter;
            AuthorizationManager authorizationManager = authorization.getAuthorizationManager();
            builder.add(arg_0 -> ((SecurityFilterChain)securityFilterChain).matches(arg_0), (authentication, context) -> (AuthorizationDecision)authorizationManager.authorize(authentication, (Object)context.getRequest()));
            mappings = true;
        }
        return mappings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.defaultExpressionHandler.setApplicationContext(applicationContext);
        try {
            this.defaultExpressionHandler.setRoleHierarchy((RoleHierarchy)applicationContext.getBean(RoleHierarchy.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.defaultExpressionHandler.setPermissionEvaluator((PermissionEvaluator)applicationContext.getBean(PermissionEvaluator.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        this.ignoredRequestRegistry = new IgnoredRequestConfigurer(applicationContext);
        try {
            this.httpFirewall = (HttpFirewall)applicationContext.getBean(HttpFirewall.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.requestRejectedHandler = (RequestRejectedHandler)applicationContext.getBean(RequestRejectedHandler.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.observationRegistry = (ObservationRegistry)applicationContext.getBean(ObservationRegistry.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        ResolvableType type = ResolvableType.forClassWithGenerics(ObjectPostProcessor.class, (Class[])new Class[]{FilterChainProxy.FilterChainDecorator.class});
        ObjectProvider postProcessor = applicationContext.getBeanProvider(type);
        this.filterChainDecoratorPostProcessor = (ObjectPostProcessor)postProcessor.getIfUnique(ObjectPostProcessor::identity);
        Class<AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer> requestTransformerClass = AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer.class;
        this.privilegeEvaluatorRequestTransformer = (AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer)applicationContext.getBeanProvider(requestTransformerClass).getIfUnique(PathPatternRequestTransformer::new);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    FilterChainProxy.FilterChainDecorator getFilterChainDecorator() {
        return (FilterChainProxy.FilterChainDecorator)this.filterChainDecoratorPostProcessor.postProcess(new FilterChainProxy.VirtualFilterChainDecorator());
    }

    @NullMarked
    private static final class SecurityExpressionHandlerAdapter
    extends AbstractSecurityExpressionHandler<FilterInvocation> {
        private final AbstractSecurityExpressionHandler<RequestAuthorizationContext> delegate;

        private SecurityExpressionHandlerAdapter(AbstractSecurityExpressionHandler<RequestAuthorizationContext> delegate) {
            this.delegate = delegate;
        }

        public EvaluationContext createEvaluationContext(Supplier<? extends @Nullable Authentication> authentication, FilterInvocation invocation) {
            RequestAuthorizationContext context = new RequestAuthorizationContext(invocation.getRequest());
            return this.delegate.createEvaluationContext(authentication, (Object)context);
        }

        protected SecurityExpressionOperations createSecurityExpressionRoot(@Nullable Authentication authentication, FilterInvocation invocation) {
            RequestAuthorizationContext context = new RequestAuthorizationContext(invocation.getRequest());
            Object operations = this.delegate.createEvaluationContext(authentication, (Object)context).getRootObject().getValue();
            Assert.isInstanceOf(SecurityExpressionOperations.class, (Object)operations, (String)"createEvaluationContext must have a SecurityExpressionOperations instance as its root");
            return (SecurityExpressionOperations)operations;
        }

        public void setApplicationContext(ApplicationContext context) {
            this.delegate.setApplicationContext(context);
            super.setApplicationContext(context);
        }

        public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
            this.delegate.setPermissionEvaluator(permissionEvaluator);
            super.setPermissionEvaluator(permissionEvaluator);
        }

        public void setRoleHierarchy(@Nullable RoleHierarchy roleHierarchy) {
            this.delegate.setRoleHierarchy(roleHierarchy);
            super.setRoleHierarchy(roleHierarchy);
        }
    }

    public class IgnoredRequestConfigurer
    extends AbstractRequestMatcherRegistry<IgnoredRequestConfigurer> {
        IgnoredRequestConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        protected IgnoredRequestConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            WebSecurity.this.ignoredRequests.addAll(requestMatchers);
            return this;
        }

        public WebSecurity and() {
            return WebSecurity.this;
        }
    }

    private static final class AccessComponents {
        private AccessComponents() {
        }

        private static boolean addAuthorizationManager(Filter filter, ServletContext servletContext, RequestMatcherDelegatingAuthorizationManager.Builder builder, SecurityFilterChain securityFilterChain) {
            if (filter instanceof FilterSecurityInterceptor) {
                FilterSecurityInterceptor securityInterceptor = (FilterSecurityInterceptor)filter;
                DefaultWebInvocationPrivilegeEvaluator privilegeEvaluator = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)securityInterceptor);
                privilegeEvaluator.setServletContext(servletContext);
                AuthorizationManager authorizationManager = (authentication, context) -> {
                    HttpServletRequest request = context.getRequest();
                    boolean result = privilegeEvaluator.isAllowed(request.getContextPath(), request.getRequestURI(), request.getMethod(), (Authentication)authentication.get());
                    return new AuthorizationDecision(result);
                };
                builder.add(arg_0 -> ((SecurityFilterChain)securityFilterChain).matches(arg_0), authorizationManager);
                return true;
            }
            return false;
        }
    }
}

