/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.ntlm;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationCredentialsNotFoundException;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.InsufficientAuthenticationException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.WebAuthenticationDetailsSource;
import org.springframework.security.ui.ntlm.NtlmBeginHandshakeException;
import org.springframework.security.ui.ntlm.NtlmType2MessageException;
import org.springframework.security.ui.ntlm.NtlmUsernamePasswordAuthenticationToken;
import org.springframework.util.Assert;

public class NtlmProcessingFilter
extends SpringSecurityFilter
implements InitializingBean {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ui$ntlm$NtlmProcessingFilter == null ? (class$org$springframework$security$ui$ntlm$NtlmProcessingFilter = NtlmProcessingFilter.class$("org.springframework.security.ui.ntlm.NtlmProcessingFilter")) : class$org$springframework$security$ui$ntlm$NtlmProcessingFilter));
    private static final String STATE_ATTR = "SpringSecurityNtlm";
    private static final String CHALLENGE_ATTR = "NtlmChal";
    private static final Integer BEGIN = new Integer(0);
    private static final Integer NEGOTIATE = new Integer(1);
    private static final Integer COMPLETE = new Integer(2);
    private static final Integer DELAYED = new Integer(3);
    private boolean loadBalance;
    private boolean stripDomain = true;
    private boolean forceIdentification = true;
    private boolean retryOnAuthFailure;
    private String soTimeout;
    private String cachePolicy;
    private String defaultDomain;
    private String domainController;
    private AuthenticationManager authenticationManager;
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    static /* synthetic */ Class class$org$springframework$security$ui$ntlm$NtlmProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)(this.soTimeout == null ? "300000" : this.soTimeout));
        Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)(this.cachePolicy == null ? "1200" : this.cachePolicy));
        if (this.domainController == null) {
            this.domainController = this.defaultDomain;
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
        Config.setProperty((String)"jcifs.smb.client.domain", (String)defaultDomain);
    }

    public void setSmbClientUsername(String smbClientUsername) {
        Config.setProperty((String)"jcifs.smb.client.username", (String)smbClientUsername);
    }

    public void setSmbClientPassword(String smbClientPassword) {
        Config.setProperty((String)"jcifs.smb.client.password", (String)smbClientPassword);
    }

    public void setSmbClientSSNLimit(String smbClientSSNLimit) {
        Config.setProperty((String)"jcifs.smb.client.ssnLimit", (String)smbClientSSNLimit);
    }

    public void setNetbiosWINS(String netbiosWINS) {
        Config.setProperty((String)"jcifs.netbios.wins", (String)netbiosWINS);
    }

    public void setDomainController(String domainController) {
        this.domainController = domainController;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setStripDomain(boolean stripDomain) {
        this.stripDomain = stripDomain;
    }

    public void setSoTimeout(String timeout) {
        this.soTimeout = timeout;
    }

    public void setCachePolicy(String numSeconds) {
        this.cachePolicy = numSeconds;
    }

    public void setJcifsProperties(Properties props) {
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jcifs.")) continue;
            Config.setProperty((String)name, (String)props.getProperty(name));
        }
    }

    public boolean isForceIdentification() {
        return this.forceIdentification;
    }

    public void setForceIdentification(boolean forceIdentification) {
        this.forceIdentification = forceIdentification;
    }

    public void setRetryOnAuthFailure(boolean retryOnFailure) {
        this.retryOnAuthFailure = retryOnFailure;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Integer ntlmState = (Integer)session.getAttribute(STATE_ATTR);
        if (ntlmState == null) {
            if (this.forceIdentification) {
                logger.debug((Object)"Starting NTLM handshake");
                session.setAttribute(STATE_ATTR, (Object)BEGIN);
                throw new NtlmBeginHandshakeException();
            }
            logger.debug((Object)"NTLM handshake not yet started");
            session.setAttribute(STATE_ATTR, (Object)DELAYED);
        }
        if (ntlmState == COMPLETE && this.reAuthOnIEPost(request)) {
            ntlmState = BEGIN;
        }
        String authMessage = request.getHeader("Authorization");
        if (ntlmState != COMPLETE && authMessage != null && authMessage.startsWith("NTLM ")) {
            UniAddress dcAddress = this.getDCAddress(session);
            if (ntlmState == BEGIN) {
                logger.debug((Object)"Processing NTLM Type 1 Message");
                session.setAttribute(STATE_ATTR, (Object)NEGOTIATE);
                this.processType1Message(authMessage, session, dcAddress);
            } else {
                logger.debug((Object)"Processing NTLM Type 3 Message");
                NtlmPasswordAuthentication auth = this.processType3Message(authMessage, session, dcAddress);
                logger.debug((Object)"NTLM negotiation complete");
                this.logon(session, dcAddress, auth);
                session.setAttribute(STATE_ATTR, (Object)COMPLETE);
                Authentication myCurrentAuth = SecurityContextHolder.getContext().getAuthentication();
                if (myCurrentAuth == null || myCurrentAuth instanceof AnonymousAuthenticationToken) {
                    logger.debug((Object)"Authenticating user credentials");
                    this.authenticate(request, response, session, auth);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean reAuthOnIEPost(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return request.getMethod().equalsIgnoreCase("POST") && ua != null && ua.indexOf("MSIE") != -1;
    }

    private void processType1Message(String message, HttpSession session, UniAddress dcAddress) throws IOException {
        Type2Message type2msg = new Type2Message(new Type1Message(Base64.decode((String)message.substring(5))), this.getChallenge(session, dcAddress), null);
        throw new NtlmType2MessageException(Base64.encode((byte[])type2msg.toByteArray()));
    }

    private NtlmPasswordAuthentication processType3Message(String message, HttpSession session, UniAddress dcAddress) throws IOException {
        Type3Message type3msg = new Type3Message(Base64.decode((String)message.substring(5)));
        byte[] lmResponse = type3msg.getLMResponse() != null ? type3msg.getLMResponse() : new byte[]{};
        byte[] ntResponse = type3msg.getNTResponse() != null ? type3msg.getNTResponse() : new byte[]{};
        return new NtlmPasswordAuthentication(type3msg.getDomain(), type3msg.getUser(), this.getChallenge(session, dcAddress), lmResponse, ntResponse);
    }

    private void logon(HttpSession session, UniAddress dcAddress, NtlmPasswordAuthentication auth) throws IOException {
        try {
            SmbSession.logon((UniAddress)dcAddress, (NtlmPasswordAuthentication)auth);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(auth + " successfully authenticated against " + dcAddress));
            }
        }
        catch (SmbAuthException e) {
            logger.error((Object)("Credentials " + auth + " were not accepted by the domain controller " + dcAddress));
            throw new BadCredentialsException("Bad NTLM credentials");
        }
        finally {
            if (this.loadBalance) {
                session.removeAttribute(CHALLENGE_ATTR);
            }
        }
    }

    private void authenticate(HttpServletRequest request, HttpServletResponse response, HttpSession session, NtlmPasswordAuthentication auth) throws IOException {
        Authentication authResult;
        NtlmUsernamePasswordAuthenticationToken authRequest = new NtlmUsernamePasswordAuthenticationToken(auth, this.stripDomain);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        session.setAttribute("SPRING_SECURITY_LAST_USERNAME", (Object)authRequest.getName());
        Authentication backupAuth = SecurityContextHolder.getContext().getAuthentication();
        try {
            authResult = this.authenticationManager.authenticate((Authentication)authRequest);
        }
        catch (AuthenticationException failed) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Authentication request for user: " + authRequest.getName() + " failed: " + failed.toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(backupAuth);
            if (this.retryOnAuthFailure && (failed instanceof AuthenticationCredentialsNotFoundException || failed instanceof InsufficientAuthenticationException)) {
                logger.debug((Object)"Restart NTLM authentication handshake due to AuthenticationException");
                session.setAttribute(STATE_ATTR, (Object)BEGIN);
                throw new NtlmBeginHandshakeException();
            }
            throw failed;
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
    }

    private UniAddress getDCAddress(HttpSession session) throws UnknownHostException, SmbException {
        if (this.loadBalance) {
            NtlmChallenge chal = (NtlmChallenge)session.getAttribute(CHALLENGE_ATTR);
            if (chal == null) {
                chal = SmbSession.getChallengeForDomain();
                session.setAttribute(CHALLENGE_ATTR, (Object)chal);
            }
            return chal.dc;
        }
        return UniAddress.getByName((String)this.domainController, (boolean)true);
    }

    private byte[] getChallenge(HttpSession session, UniAddress dcAddress) throws UnknownHostException, SmbException {
        if (this.loadBalance) {
            return ((NtlmChallenge)session.getAttribute((String)CHALLENGE_ATTR)).challenge;
        }
        return SmbSession.getChallenge((UniAddress)dcAddress);
    }

    public int getOrder() {
        return FilterChainOrder.NTLM_FILTER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

