/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.ntlm;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.ntlm.NtlmBaseException;
import org.springframework.security.ui.ntlm.NtlmType2MessageException;
import org.springframework.util.Assert;

public class NtlmProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ui$ntlm$NtlmProcessingFilterEntryPoint == null ? (class$org$springframework$security$ui$ntlm$NtlmProcessingFilterEntryPoint = NtlmProcessingFilterEntryPoint.class$("org.springframework.security.ui.ntlm.NtlmProcessingFilterEntryPoint")) : class$org$springframework$security$ui$ntlm$NtlmProcessingFilterEntryPoint));
    private String authenticationFailureUrl;
    static /* synthetic */ Class class$org$springframework$security$ui$ntlm$NtlmProcessingFilterEntryPoint;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.authenticationFailureUrl, (String)"authenticationFailureUrl must be specified");
    }

    public void setAuthenticationFailureUrl(String authenticationFailureUrl) {
        this.authenticationFailureUrl = authenticationFailureUrl;
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        if (authException instanceof NtlmBaseException) {
            if (authException instanceof NtlmType2MessageException) {
                ((NtlmType2MessageException)authException).preserveAuthentication();
            }
            resp.setHeader("WWW-Authenticate", authException.getMessage());
            resp.setHeader("Connection", "Keep-Alive");
            resp.setStatus(401);
            resp.setContentLength(0);
            resp.flushBuffer();
        } else {
            String url = this.authenticationFailureUrl;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = ((HttpServletRequest)request).getContextPath() + url;
            }
            resp.sendRedirect(resp.encodeRedirectURL(url));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

