/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthorizationRequestRedirectFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_AUTHORIZATION_REQUEST_BASE_URI = "/oauth2/authorization";
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final AntPathRequestMatcher authorizationRequestMatcher;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizationRequestUriBuilder authorizationRequestUriBuilder = new OAuth2AuthorizationRequestUriBuilder();
    private final RedirectStrategy authorizationRedirectStrategy = new DefaultRedirectStrategy();
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = new HttpSessionOAuth2AuthorizationRequestRepository();

    public OAuth2AuthorizationRequestRedirectFilter(ClientRegistrationRepository clientRegistrationRepository) {
        this(clientRegistrationRepository, DEFAULT_AUTHORIZATION_REQUEST_BASE_URI);
    }

    public OAuth2AuthorizationRequestRedirectFilter(ClientRegistrationRepository clientRegistrationRepository, String authorizationRequestBaseUri) {
        Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.authorizationRequestMatcher = new AntPathRequestMatcher(authorizationRequestBaseUri + "/{" + REGISTRATION_ID_URI_VARIABLE_NAME + "}");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public final void setAuthorizationRequestRepository(AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
        Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.shouldRequestAuthorization(request, response)) {
            try {
                this.sendRedirectForAuthorization(request, response);
            }
            catch (Exception failed) {
                this.unsuccessfulRedirectForAuthorization(request, response, failed);
            }
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean shouldRequestAuthorization(HttpServletRequest request, HttpServletResponse response) {
        return this.authorizationRequestMatcher.matches(request);
    }

    private void sendRedirectForAuthorization(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OAuth2AuthorizationRequest.Builder builder;
        String registrationId = (String)this.authorizationRequestMatcher.extractUriTemplateVariables(request).get(REGISTRATION_ID_URI_VARIABLE_NAME);
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        if (clientRegistration == null) {
            throw new IllegalArgumentException("Invalid Client Registration with Id: " + registrationId);
        }
        String redirectUriStr = this.expandRedirectUri(request, clientRegistration);
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("registration_id", clientRegistration.getRegistrationId());
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
        } else if (AuthorizationGrantType.IMPLICIT.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.implicit();
        } else {
            throw new IllegalArgumentException("Invalid Authorization Grant Type for Client Registration (" + clientRegistration.getRegistrationId() + "): " + clientRegistration.getAuthorizationGrantType());
        }
        OAuth2AuthorizationRequest authorizationRequest = builder.clientId(clientRegistration.getClientId()).authorizationUri(clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(redirectUriStr).scopes(clientRegistration.getScopes()).state(this.stateGenerator.generateKey()).additionalParameters(additionalParameters).build();
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationRequest.getGrantType())) {
            this.authorizationRequestRepository.saveAuthorizationRequest(authorizationRequest, request, response);
        }
        URI redirectUri = this.authorizationRequestUriBuilder.build(authorizationRequest);
        this.authorizationRedirectStrategy.sendRedirect(request, response, redirectUri.toString());
    }

    private void unsuccessfulRedirectForAuthorization(HttpServletRequest request, HttpServletResponse response, Exception failed) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authorization Request failed: " + failed.toString()), (Throwable)failed);
        }
        response.sendError(HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase());
    }

    private String expandRedirectUri(HttpServletRequest request, ClientRegistration clientRegistration) {
        int port = request.getServerPort();
        if ("http".equals(request.getScheme()) && port == 80 || "https".equals(request.getScheme()) && port == 443) {
            port = -1;
        }
        String baseUrl = UriComponentsBuilder.newInstance().scheme(request.getScheme()).host(request.getServerName()).port(port).path(request.getContextPath()).build().toUriString();
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("baseUrl", baseUrl);
        uriVariables.put(REGISTRATION_ID_URI_VARIABLE_NAME, clientRegistration.getRegistrationId());
        return UriComponentsBuilder.fromUriString((String)clientRegistration.getRedirectUriTemplate()).buildAndExpand(uriVariables).toUriString();
    }
}

