/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.OidcTokenValidator;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class OidcAuthorizationCodeReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private static final String INVALID_STATE_PARAMETER_ERROR_CODE = "invalid_state_parameter";
    private static final String INVALID_ID_TOKEN_ERROR_CODE = "invalid_id_token";
    private static final String MISSING_SIGNATURE_VERIFIER_ERROR_CODE = "missing_signature_verifier";
    private final ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;
    private final ReactiveOAuth2UserService<OidcUserRequest, OidcUser> userService;
    private GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;
    private Function<ClientRegistration, ReactiveJwtDecoder> decoderFactory = new DefaultDecoderFactory();

    public OidcAuthorizationCodeReactiveAuthenticationManager(ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, ReactiveOAuth2UserService<OidcUserRequest, OidcUser> userService) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        Assert.notNull(userService, (String)"userService cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
        this.userService = userService;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.defer(() -> {
            OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
            if (!authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest().getScopes().contains("openid")) {
                return Mono.empty();
            }
            OAuth2AuthorizationRequest authorizationRequest = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest();
            OAuth2AuthorizationResponse authorizationResponse = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationResponse();
            if (authorizationResponse.statusError()) {
                return Mono.error((Throwable)new OAuth2AuthenticationException(authorizationResponse.getError(), authorizationResponse.getError().toString()));
            }
            if (!authorizationResponse.getState().equals(authorizationRequest.getState())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_STATE_PARAMETER_ERROR_CODE);
                return Mono.error((Throwable)new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString()));
            }
            OAuth2AuthorizationCodeGrantRequest authzRequest = new OAuth2AuthorizationCodeGrantRequest(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange());
            return this.accessTokenResponseClient.getTokenResponse(authzRequest).flatMap(accessTokenResponse -> this.authenticationResult(authorizationCodeAuthentication, (OAuth2AccessTokenResponse)accessTokenResponse)).onErrorMap(OAuth2AuthorizationException.class, e -> new OAuth2AuthenticationException(e.getError(), e.getError().toString()));
        });
    }

    void setDecoderFactory(Function<ClientRegistration, ReactiveJwtDecoder> decoderFactory) {
        Assert.notNull(decoderFactory, (String)"decoderFactory cannot be null");
        this.decoderFactory = decoderFactory;
    }

    private Mono<OAuth2LoginAuthenticationToken> authenticationResult(OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication, OAuth2AccessTokenResponse accessTokenResponse) {
        OAuth2AccessToken accessToken = accessTokenResponse.getAccessToken();
        ClientRegistration clientRegistration = authorizationCodeAuthentication.getClientRegistration();
        Map additionalParameters = accessTokenResponse.getAdditionalParameters();
        if (!additionalParameters.containsKey("id_token")) {
            OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Missing (required) ID Token in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), null);
            return Mono.error((Throwable)new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString()));
        }
        return this.createOidcToken(clientRegistration, accessTokenResponse).map(idToken -> new OidcUserRequest(clientRegistration, accessToken, (OidcIdToken)idToken, additionalParameters)).flatMap(this.userService::loadUser).map(oauth2User -> {
            Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oauth2User.getAuthorities());
            return new OAuth2LoginAuthenticationToken(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange(), (OAuth2User)oauth2User, mappedAuthorities, accessToken, accessTokenResponse.getRefreshToken());
        });
    }

    private Mono<OidcIdToken> createOidcToken(ClientRegistration clientRegistration, OAuth2AccessTokenResponse accessTokenResponse) {
        ReactiveJwtDecoder jwtDecoder = this.decoderFactory.apply(clientRegistration);
        String rawIdToken = (String)accessTokenResponse.getAdditionalParameters().get("id_token");
        return jwtDecoder.decode(rawIdToken).map(jwt -> new OidcIdToken(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getClaims())).doOnNext(idToken -> OidcTokenValidator.validateIdToken(idToken, clientRegistration));
    }

    private static class DefaultDecoderFactory
    implements Function<ClientRegistration, ReactiveJwtDecoder> {
        private final Map<String, ReactiveJwtDecoder> jwtDecoders = new ConcurrentHashMap<String, ReactiveJwtDecoder>();

        private DefaultDecoderFactory() {
        }

        @Override
        public ReactiveJwtDecoder apply(ClientRegistration clientRegistration) {
            ReactiveJwtDecoder jwtDecoder = this.jwtDecoders.get(clientRegistration.getRegistrationId());
            if (jwtDecoder == null) {
                if (!StringUtils.hasText((String)clientRegistration.getProviderDetails().getJwkSetUri())) {
                    OAuth2Error oauth2Error = new OAuth2Error(OidcAuthorizationCodeReactiveAuthenticationManager.MISSING_SIGNATURE_VERIFIER_ERROR_CODE, "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the JwkSet URI.", null);
                    throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
                }
                jwtDecoder = new NimbusReactiveJwtDecoder(clientRegistration.getProviderDetails().getJwkSetUri());
                this.jwtDecoders.put(clientRegistration.getRegistrationId(), jwtDecoder);
            }
            return jwtDecoder;
        }
    }
}

