/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class WebClientReactiveClientCredentialsTokenResponseClient
implements ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> {
    private WebClient webClient = WebClient.builder().build();

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2ClientCredentialsGrantRequest authorizationGrantRequest) {
        return Mono.defer(() -> {
            ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
            String tokenUri = clientRegistration.getProviderDetails().getTokenUri();
            BodyInserters.FormInserter<String> body = WebClientReactiveClientCredentialsTokenResponseClient.body(authorizationGrantRequest);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(tokenUri, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).headers(this.headers(clientRegistration))).body(body).exchange().flatMap(response -> {
                HttpStatus status = HttpStatus.resolve((int)response.rawStatusCode());
                if (status == null || !status.is2xxSuccessful()) {
                    return response.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)WebClientResponseException.create((int)response.rawStatusCode(), (String)"Cannot get token, expected 2xx HTTP Status code", null, null, null)));
                }
                return (Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse());
            }).map(response -> {
                if (response.getAccessToken().getScopes().isEmpty()) {
                    response = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)response).scopes(authorizationGrantRequest.getClientRegistration().getScopes()).build();
                }
                return response;
            });
        });
    }

    private Consumer<HttpHeaders> headers(ClientRegistration clientRegistration) {
        return headers -> {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                String clientId = WebClientReactiveClientCredentialsTokenResponseClient.encodeClientCredential(clientRegistration.getClientId());
                String clientSecret = WebClientReactiveClientCredentialsTokenResponseClient.encodeClientCredential(clientRegistration.getClientSecret());
                headers.setBasicAuth(clientId, clientSecret);
            }
        };
    }

    private static String encodeClientCredential(String clientCredential) {
        try {
            return URLEncoder.encode(clientCredential, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static BodyInserters.FormInserter<String> body(OAuth2ClientCredentialsGrantRequest authorizationGrantRequest) {
        ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)authorizationGrantRequest.getGrantType().getValue());
        Set<String> scopes = clientRegistration.getScopes();
        if (!CollectionUtils.isEmpty(scopes)) {
            String scope = StringUtils.collectionToDelimitedString(scopes, (String)" ");
            body.with("scope", (Object)scope);
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        return body;
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }
}

