/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;

@Deprecated
public class NimbusAuthorizationCodeTokenResponseClient
implements OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";

    @Override
    public OAuth2AccessTokenResponse getTokenResponse(OAuth2AuthorizationCodeGrantRequest authorizationGrantRequest) {
        ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
        AuthorizationCode authorizationCode = new AuthorizationCode(authorizationGrantRequest.getAuthorizationExchange().getAuthorizationResponse().getCode());
        URI redirectUri = NimbusAuthorizationCodeTokenResponseClient.toURI(authorizationGrantRequest.getAuthorizationExchange().getAuthorizationRequest().getRedirectUri());
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(authorizationCode, redirectUri);
        URI tokenUri = NimbusAuthorizationCodeTokenResponseClient.toURI(clientRegistration.getProviderDetails().getTokenUri());
        ClientID clientId = new ClientID(clientRegistration.getClientId());
        Secret clientSecret = new Secret(clientRegistration.getClientSecret());
        boolean isPost = ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod());
        Object clientAuthentication = isPost ? new ClientSecretPost(clientId, clientSecret) : new ClientSecretBasic(clientId, clientSecret);
        TokenResponse tokenResponse = this.getTokenResponse((AuthorizationGrant)authorizationCodeGrant, tokenUri, (ClientAuthentication)clientAuthentication);
        if (!tokenResponse.indicatesSuccess()) {
            TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)tokenResponse;
            ErrorObject errorObject = tokenErrorResponse.getErrorObject();
            throw new OAuth2AuthorizationException(this.getOAuthError(errorObject));
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)tokenResponse;
        String accessToken = accessTokenResponse.getTokens().getAccessToken().getValue();
        OAuth2AccessToken.TokenType accessTokenType = null;
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(accessTokenResponse.getTokens().getAccessToken().getType().getValue())) {
            accessTokenType = OAuth2AccessToken.TokenType.BEARER;
        }
        long expiresIn = accessTokenResponse.getTokens().getAccessToken().getLifetime();
        Set<String> scopes = this.getScopes(authorizationGrantRequest, accessTokenResponse);
        String refreshToken = null;
        if (accessTokenResponse.getTokens().getRefreshToken() != null) {
            refreshToken = accessTokenResponse.getTokens().getRefreshToken().getValue();
        }
        LinkedHashMap additionalParameters = new LinkedHashMap(accessTokenResponse.getCustomParameters());
        return OAuth2AccessTokenResponse.withToken((String)accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }

    private TokenResponse getTokenResponse(AuthorizationGrant authorizationCodeGrant, URI tokenUri, ClientAuthentication clientAuthentication) {
        try {
            TokenRequest tokenRequest = new TokenRequest(tokenUri, clientAuthentication, authorizationCodeGrant);
            HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
            httpRequest.setAccept("application/json");
            httpRequest.setConnectTimeout(30000);
            httpRequest.setReadTimeout(30000);
            return TokenResponse.parse((HTTPResponse)httpRequest.send());
        }
        catch (ParseException | IOException ex) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the OAuth 2.0 Access Token Response: " + ex.getMessage(), null);
            throw new OAuth2AuthorizationException(oauth2Error, ex);
        }
    }

    private Set<String> getScopes(OAuth2AuthorizationCodeGrantRequest authorizationGrantRequest, AccessTokenResponse accessTokenResponse) {
        if (CollectionUtils.isEmpty((Collection)accessTokenResponse.getTokens().getAccessToken().getScope())) {
            return new LinkedHashSet<String>(authorizationGrantRequest.getAuthorizationExchange().getAuthorizationRequest().getScopes());
        }
        return new LinkedHashSet<String>(accessTokenResponse.getTokens().getAccessToken().getScope().toStringList());
    }

    private OAuth2Error getOAuthError(ErrorObject errorObject) {
        if (errorObject == null) {
            return new OAuth2Error("server_error");
        }
        String errorCode = errorObject.getCode() != null ? errorObject.getCode() : "server_error";
        String description = errorObject.getDescription();
        String uri = errorObject.getURI() != null ? errorObject.getURI().toString() : null;
        return new OAuth2Error(errorCode, description, uri);
    }

    private static URI toURI(String uriStr) {
        try {
            return new URI(uriStr);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("An error occurred parsing URI: " + uriStr, ex);
        }
    }
}

