/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.JWKContext;
import org.springframework.security.oauth2.jwt.JWKContextJWKSource;
import org.springframework.security.oauth2.jwt.JWKSelectorFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.ReactiveJWKSource;
import org.springframework.security.oauth2.jwt.ReactiveJWKSourceAdapter;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveRemoteJWKSource;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class NimbusReactiveJwtDecoder
implements ReactiveJwtDecoder {
    private final JWTProcessor<JWKContext> jwtProcessor;
    private final ReactiveJWKSource reactiveJwkSource;
    private final JWKSelectorFactory jwkSelectorFactory;
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();

    public NimbusReactiveJwtDecoder(RSAPublicKey publicKey) {
        JWSAlgorithm algorithm = JWSAlgorithm.parse((String)"RS256");
        RSAKey rsaKey = NimbusReactiveJwtDecoder.rsaKey(publicKey);
        JWKSet jwkSet = new JWKSet((JWK)rsaKey);
        ImmutableJWKSet jwkSource = new ImmutableJWKSet(jwkSet);
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(algorithm, (JWKSource)jwkSource);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
        this.jwtProcessor = jwtProcessor;
        this.reactiveJwkSource = new ReactiveJWKSourceAdapter((JWKSource<SecurityContext>)jwkSource);
        this.jwkSelectorFactory = new JWKSelectorFactory(algorithm);
    }

    public NimbusReactiveJwtDecoder(String jwkSetUrl) {
        Assert.hasText((String)jwkSetUrl, (String)"jwkSetUrl cannot be empty");
        String jwsAlgorithm = "RS256";
        JWSAlgorithm algorithm = JWSAlgorithm.parse((String)jwsAlgorithm);
        JWKContextJWKSource jwkSource = new JWKContextJWKSource();
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(algorithm, (JWKSource)jwkSource);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
        this.jwtProcessor = jwtProcessor;
        this.reactiveJwkSource = new ReactiveRemoteJWKSource(jwkSetUrl);
        this.jwkSelectorFactory = new JWKSelectorFactory(algorithm);
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    @Override
    public Mono<Jwt> decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof SignedJWT) {
            return this.decode((SignedJWT)jwt);
        }
        throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
    }

    private Mono<Jwt> decode(SignedJWT parsedToken) {
        try {
            JWKSelector selector = this.jwkSelectorFactory.createSelector(parsedToken.getHeader());
            return this.reactiveJwkSource.get(selector).onErrorMap(e -> new IllegalStateException("Could not obtain the keys", (Throwable)e)).map(jwkList -> this.createClaimsSet((JWT)parsedToken, (List<JWK>)jwkList)).map(set -> this.createJwt((JWT)parsedToken, (JWTClaimsSet)set)).map(this::validateJwt).onErrorMap(e -> !(e instanceof IllegalStateException) && !(e instanceof JwtException), e -> new JwtException("An error occurred while attempting to decode the Jwt: ", (Throwable)e));
        }
        catch (RuntimeException ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
    }

    private JWTClaimsSet createClaimsSet(JWT parsedToken, List<JWK> jwkList) {
        try {
            return this.jwtProcessor.process(parsedToken, (SecurityContext)new JWKContext(jwkList));
        }
        catch (JOSEException | BadJOSEException e) {
            throw new JwtException("Failed to validate the token", e);
        }
    }

    private Jwt createJwt(JWT parsedJwt, JWTClaimsSet jwtClaimsSet) {
        Instant expiresAt = null;
        if (jwtClaimsSet.getExpirationTime() != null) {
            expiresAt = jwtClaimsSet.getExpirationTime().toInstant();
        }
        Instant issuedAt = null;
        if (jwtClaimsSet.getIssueTime() != null) {
            issuedAt = jwtClaimsSet.getIssueTime().toInstant();
        } else if (expiresAt != null) {
            issuedAt = Instant.from(expiresAt).minusSeconds(1L);
        }
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>((Map<String, Object>)parsedJwt.getHeader().toJSONObject());
        return new Jwt(parsedJwt.getParsedString(), issuedAt, expiresAt, headers, jwtClaimsSet.getClaims());
    }

    private Jwt validateJwt(Jwt jwt) {
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((AbstractOAuth2Token)jwt);
        if (result.hasErrors()) {
            String message = ((OAuth2Error)result.getErrors().iterator().next()).getDescription();
            throw new JwtValidationException(message, result.getErrors());
        }
        return jwt;
    }

    private static RSAKey rsaKey(RSAPublicKey publicKey) {
        return new RSAKey.Builder(publicKey).build();
    }
}

