/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OpaqueTokenReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ReactiveOpaqueTokenIntrospector introspector;
    private ReactiveOpaqueTokenAuthenticationConverter authenticationConverter = OpaqueTokenReactiveAuthenticationManager::convert;

    public OpaqueTokenReactiveAuthenticationManager(ReactiveOpaqueTokenIntrospector introspector) {
        Assert.notNull((Object)introspector, (String)"introspector cannot be null");
        this.introspector = introspector;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(BearerTokenAuthenticationToken.class::isInstance).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(this::authenticate);
    }

    private Mono<Authentication> authenticate(String token) {
        return this.introspector.introspect(token).flatMap(principal -> this.authenticationConverter.convert(token, (OAuth2AuthenticatedPrincipal)principal)).onErrorMap(OAuth2IntrospectionException.class, this::onError);
    }

    private AuthenticationException onError(OAuth2IntrospectionException ex) {
        if (ex instanceof BadOpaqueTokenException) {
            return new InvalidBearerTokenException(ex.getMessage(), ex);
        }
        return new AuthenticationServiceException(ex.getMessage(), (Throwable)ex);
    }

    static Mono<Authentication> convert(String introspectedToken, OAuth2AuthenticatedPrincipal authenticatedPrincipal) {
        return Mono.just((Object)((Object)OpaqueTokenAuthenticationProvider.convert(introspectedToken, authenticatedPrincipal)));
    }

    public void setAuthenticationConverter(ReactiveOpaqueTokenAuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }
}

