/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.openid.MockOpenIDConsumer;
import org.springframework.security.openid.OpenIDAuthenticationFilter;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class OpenIDAuthenticationFilterTests {
    OpenIDAuthenticationFilter filter;
    private static final String REDIRECT_URL = "http://www.example.com/redirect";
    private static final String CLAIMED_IDENTITY_URL = "http://www.example.com/identity";
    private static final String REQUEST_PATH = "/j_spring_openid_security_check";
    private static final String FILTER_PROCESS_URL = "http://localhost:80/j_spring_openid_security_check";
    private static final String DEFAULT_TARGET_URL = "http://localhost:80/j_spring_openid_security_check";

    @Before
    public void setUp() throws Exception {
        this.filter = new OpenIDAuthenticationFilter();
        this.filter.setConsumer((OpenIDConsumer)new MockOpenIDConsumer(REDIRECT_URL));
        SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        this.filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler());
        successHandler.setDefaultTargetUrl("http://localhost:80/j_spring_openid_security_check");
        this.filter.setAuthenticationManager(new AuthenticationManager(){

            public Authentication authenticate(Authentication a) {
                return a;
            }
        });
        this.filter.afterPropertiesSet();
    }

    @Test
    public void testFilterOperation() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest("GET", REQUEST_PATH);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setParameter("openid_identifier", " http://www.example.com/identity");
        req.setRemoteHost("www.example.com");
        this.filter.setConsumer((OpenIDConsumer)new MockOpenIDConsumer(){

            public String beginConsumption(HttpServletRequest req, String claimedIdentity, String returnToUrl, String realm) throws OpenIDConsumerException {
                Assert.assertEquals((Object)OpenIDAuthenticationFilterTests.CLAIMED_IDENTITY_URL, (Object)claimedIdentity);
                Assert.assertEquals((Object)"http://localhost:80/j_spring_openid_security_check", (Object)returnToUrl);
                Assert.assertEquals((Object)"http://localhost:80/", (Object)realm);
                return OpenIDAuthenticationFilterTests.REDIRECT_URL;
            }
        });
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)response, fc);
        Assert.assertEquals((Object)REDIRECT_URL, (Object)response.getRedirectedUrl());
        ((FilterChain)Mockito.verify((Object)fc, (VerificationMode)Mockito.never())).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
    }
}

