/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.util.Collection;
import junit.framework.TestCase;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.openid.AuthenticationCancelledException;
import org.springframework.security.openid.OpenIDAuthenticationProvider;
import org.springframework.security.openid.OpenIDAuthenticationStatus;
import org.springframework.security.openid.OpenIDAuthenticationToken;

public class OpenIDAuthenticationProviderTests
extends TestCase {
    private static final String USERNAME = "user.acegiopenid.com";

    public void testAuthenticateCancel() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationToken preAuth = new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.CANCELLED, USERNAME, "", null);
        OpenIDAuthenticationProviderTests.assertFalse((boolean)preAuth.isAuthenticated());
        try {
            provider.authenticate((Authentication)preAuth);
            OpenIDAuthenticationProviderTests.fail((String)"Should throw an AuthenticationException");
        }
        catch (AuthenticationCancelledException expected) {
            OpenIDAuthenticationProviderTests.assertEquals((String)"Log in cancelled", (String)expected.getMessage());
        }
    }

    public void testAuthenticateError() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationToken preAuth = new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.ERROR, USERNAME, "", null);
        OpenIDAuthenticationProviderTests.assertFalse((boolean)preAuth.isAuthenticated());
        try {
            provider.authenticate((Authentication)preAuth);
            OpenIDAuthenticationProviderTests.fail((String)"Should throw an AuthenticationException");
        }
        catch (AuthenticationServiceException expected) {
            OpenIDAuthenticationProviderTests.assertEquals((String)"Error message from server: ", (String)expected.getMessage());
        }
    }

    public void testAuthenticateFailure() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationToken preAuth = new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.FAILURE, USERNAME, "", null);
        OpenIDAuthenticationProviderTests.assertFalse((boolean)preAuth.isAuthenticated());
        try {
            provider.authenticate((Authentication)preAuth);
            OpenIDAuthenticationProviderTests.fail((String)"Should throw an AuthenticationException");
        }
        catch (BadCredentialsException expected) {
            OpenIDAuthenticationProviderTests.assertEquals((String)"Log in failed - identity could not be verified", (String)expected.getMessage());
        }
    }

    public void testAuthenticateSetupNeeded() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationToken preAuth = new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.SETUP_NEEDED, USERNAME, "", null);
        OpenIDAuthenticationProviderTests.assertFalse((boolean)preAuth.isAuthenticated());
        try {
            provider.authenticate((Authentication)preAuth);
            OpenIDAuthenticationProviderTests.fail((String)"Should throw an AuthenticationException");
        }
        catch (AuthenticationServiceException expected) {
            OpenIDAuthenticationProviderTests.assertEquals((String)"The server responded setup was needed, which shouldn't happen", (String)expected.getMessage());
        }
    }

    public void testAuthenticateSuccess() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationToken preAuth = new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.SUCCESS, USERNAME, "", null);
        OpenIDAuthenticationProviderTests.assertFalse((boolean)preAuth.isAuthenticated());
        Authentication postAuth = provider.authenticate((Authentication)preAuth);
        OpenIDAuthenticationProviderTests.assertNotNull((Object)postAuth);
        OpenIDAuthenticationProviderTests.assertTrue((boolean)(postAuth instanceof OpenIDAuthenticationToken));
        OpenIDAuthenticationProviderTests.assertTrue((boolean)postAuth.isAuthenticated());
        OpenIDAuthenticationProviderTests.assertNotNull((Object)postAuth.getPrincipal());
        OpenIDAuthenticationProviderTests.assertTrue((boolean)(postAuth.getPrincipal() instanceof UserDetails));
        OpenIDAuthenticationProviderTests.assertNotNull((Object)postAuth.getAuthorities());
        OpenIDAuthenticationProviderTests.assertTrue((postAuth.getAuthorities().size() > 0 ? 1 : 0) != 0);
        OpenIDAuthenticationProviderTests.assertTrue((((OpenIDAuthenticationToken)postAuth).getStatus() == OpenIDAuthenticationStatus.SUCCESS ? 1 : 0) != 0);
        OpenIDAuthenticationProviderTests.assertTrue((((OpenIDAuthenticationToken)postAuth).getMessage() == null ? 1 : 0) != 0);
    }

    public void testDetectsMissingAuthoritiesPopulator() throws Exception {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            OpenIDAuthenticationProviderTests.fail((String)"Should have thrown Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDoesntSupport() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationProviderTests.assertFalse((boolean)provider.supports(UsernamePasswordAuthenticationToken.class));
    }

    public void testIgnoresUserPassAuthToken() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)USERNAME, (Object)"password");
        OpenIDAuthenticationProviderTests.assertEquals(null, (Object)provider.authenticate((Authentication)token));
    }

    public void testSupports() {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        OpenIDAuthenticationProviderTests.assertTrue((boolean)provider.supports(OpenIDAuthenticationToken.class));
    }

    public void testValidation() throws Exception {
        OpenIDAuthenticationProvider provider = new OpenIDAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        provider.afterPropertiesSet();
        provider.setUserDetailsService(null);
        try {
            provider.afterPropertiesSet();
            OpenIDAuthenticationProviderTests.fail((String)"IllegalArgumentException expected, ssoAuthoritiesPopulator is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class MockUserDetailsService
    implements UserDetailsService {
        MockUserDetailsService() {
        }

        public UserDetails loadUserByUsername(String ssoUserId) throws AuthenticationException {
            return new User(ssoUserId, "password", true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_A", "ROLE_B"}));
        }
    }
}

