/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.openid.AuthenticationCancelledException;
import org.springframework.security.openid.OpenIDAuthenticationStatus;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.util.Assert;

public class OpenIDAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private AuthenticationUserDetailsService<OpenIDAuthenticationToken> userDetailsService;
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.userDetailsService, (String)"The userDetailsService must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof OpenIDAuthenticationToken) {
            OpenIDAuthenticationToken response = (OpenIDAuthenticationToken)authentication;
            OpenIDAuthenticationStatus status = response.getStatus();
            if (status == OpenIDAuthenticationStatus.SUCCESS) {
                UserDetails userDetails = this.userDetailsService.loadUserDetails((Authentication)response);
                return this.createSuccessfulAuthentication(userDetails, response);
            }
            if (status == OpenIDAuthenticationStatus.CANCELLED) {
                throw new AuthenticationCancelledException("Log in cancelled");
            }
            if (status == OpenIDAuthenticationStatus.ERROR) {
                throw new AuthenticationServiceException("Error message from server: " + response.getMessage());
            }
            if (status == OpenIDAuthenticationStatus.FAILURE) {
                throw new BadCredentialsException("Log in failed - identity could not be verified");
            }
            if (status == OpenIDAuthenticationStatus.SETUP_NEEDED) {
                throw new AuthenticationServiceException("The server responded setup was needed, which shouldn't happen");
            }
            throw new AuthenticationServiceException("Unrecognized return value " + status.toString());
        }
        return null;
    }

    protected Authentication createSuccessfulAuthentication(UserDetails userDetails, OpenIDAuthenticationToken auth) {
        return new OpenIDAuthenticationToken(userDetails, this.authoritiesMapper.mapAuthorities(userDetails.getAuthorities()), auth.getIdentityUrl(), auth.getAttributes());
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = new UserDetailsByNameServiceWrapper(userDetailsService);
    }

    public void setAuthenticationUserDetailsService(AuthenticationUserDetailsService<OpenIDAuthenticationToken> userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public boolean supports(Class<?> authentication) {
        return OpenIDAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }
}

