/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.authentication;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.metadata.AuthMetadataCodec;
import io.rsocket.metadata.WellKnownAuthType;
import io.rsocket.metadata.WellKnownMimeType;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.Decoder;
import org.springframework.messaging.rsocket.DefaultMetadataExtractor;
import org.springframework.messaging.rsocket.MetadataExtractor;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.authentication.PayloadExchangeAuthenticationConverter;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Mono;

public class AuthenticationPayloadExchangeConverter
implements PayloadExchangeAuthenticationConverter {
    private static final MimeType COMPOSITE_METADATA_MIME_TYPE = MimeTypeUtils.parseMimeType((String)WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString());
    private static final MimeType AUTHENTICATION_MIME_TYPE = MimeTypeUtils.parseMimeType((String)WellKnownMimeType.MESSAGE_RSOCKET_AUTHENTICATION.getString());
    private final MetadataExtractor metadataExtractor = AuthenticationPayloadExchangeConverter.createDefaultExtractor();

    @Override
    public Mono<Authentication> convert(PayloadExchange exchange) {
        return Mono.fromCallable(() -> this.metadataExtractor.extract(exchange.getPayload(), COMPOSITE_METADATA_MIME_TYPE)).flatMap(metadata -> Mono.justOrEmpty((Object)this.authentication((Map<String, Object>)metadata)));
    }

    private Authentication authentication(Map<String, Object> metadata) {
        byte[] authenticationMetadata = (byte[])metadata.get("authentication");
        if (authenticationMetadata == null) {
            return null;
        }
        ByteBuf rawAuthentication = ByteBufAllocator.DEFAULT.buffer().writeBytes(authenticationMetadata);
        if (!AuthMetadataCodec.isWellKnownAuthType((ByteBuf)rawAuthentication)) {
            return null;
        }
        WellKnownAuthType wellKnownAuthType = AuthMetadataCodec.readWellKnownAuthType((ByteBuf)rawAuthentication);
        if (WellKnownAuthType.SIMPLE.equals((Object)wellKnownAuthType)) {
            return this.simple(rawAuthentication);
        }
        if (WellKnownAuthType.BEARER.equals((Object)wellKnownAuthType)) {
            return this.bearer(rawAuthentication);
        }
        throw new IllegalArgumentException("Unknown Mime Type " + wellKnownAuthType);
    }

    private Authentication simple(ByteBuf rawAuthentication) {
        ByteBuf rawUsername = AuthMetadataCodec.readUsername((ByteBuf)rawAuthentication);
        String username = rawUsername.toString(StandardCharsets.UTF_8);
        ByteBuf rawPassword = AuthMetadataCodec.readPassword((ByteBuf)rawAuthentication);
        String password = rawPassword.toString(StandardCharsets.UTF_8);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
    }

    private Authentication bearer(ByteBuf rawAuthentication) {
        char[] rawToken = AuthMetadataCodec.readBearerTokenAsCharArray((ByteBuf)rawAuthentication);
        String token = new String(rawToken);
        return new BearerTokenAuthenticationToken(token);
    }

    private static MetadataExtractor createDefaultExtractor() {
        DefaultMetadataExtractor result = new DefaultMetadataExtractor(new Decoder[]{new ByteArrayDecoder()});
        result.metadataToExtract(AUTHENTICATION_MIME_TYPE, byte[].class, "authentication");
        return result;
    }
}

