/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class Saml2Utils {
    private static final char PATH_DELIMITER = '/';
    private static Base64.Encoder ENCODER = Base64.getEncoder();
    private static Base64.Decoder DECODER = Base64.getDecoder();

    Saml2Utils() {
    }

    static String encode(byte[] b) {
        return ENCODER.encodeToString(b);
    }

    static byte[] decode(String s) {
        return DECODER.decode(s);
    }

    static byte[] deflate(String s) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)b, new Deflater(8, true));
            deflater.write(s.getBytes(StandardCharsets.UTF_8));
            deflater.finish();
            return b.toByteArray();
        }
        catch (IOException e) {
            throw new Saml2Exception("Unable to deflate string", e);
        }
    }

    static String inflate(byte[] b) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream iout = new InflaterOutputStream(out, new Inflater(true));
            iout.write(b);
            iout.finish();
            return new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new Saml2Exception("Unable to inflate string", e);
        }
    }

    static String getServiceProviderEntityId(RelyingPartyRegistration rp, HttpServletRequest request) {
        return Saml2Utils.resolveUrlTemplate(rp.getLocalEntityIdTemplate(), Saml2Utils.getApplicationUri(request), rp.getRemoteIdpEntityId(), rp.getRegistrationId());
    }

    static String resolveUrlTemplate(String template, String baseUrl, String entityId, String registrationId) {
        if (!StringUtils.hasText((String)template)) {
            return baseUrl;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseUrl).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme == null ? "" : scheme);
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host == null ? "" : host);
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        String path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        uriVariables.put("basePath", path == null ? "" : path);
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("entityId", StringUtils.hasText((String)entityId) ? entityId : "");
        uriVariables.put("registrationId", StringUtils.hasText((String)registrationId) ? registrationId : "");
        return UriComponentsBuilder.fromUriString((String)template).buildAndExpand(uriVariables).toUriString();
    }

    static String getApplicationUri(HttpServletRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return uriComponents.toUriString();
    }
}

