/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2Utils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class Saml2WebSsoAuthenticationRequestFilter
extends OncePerRequestFilter {
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private RequestMatcher redirectMatcher = new AntPathRequestMatcher("/saml2/authenticate/{registrationId}");
    private Saml2AuthenticationRequestFactory authenticationRequestFactory = new OpenSamlAuthenticationRequestFactory();

    public Saml2WebSsoAuthenticationRequestFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
    }

    public void setAuthenticationRequestFactory(Saml2AuthenticationRequestFactory authenticationRequestFactory) {
        Assert.notNull((Object)authenticationRequestFactory, (String)"authenticationRequestFactory cannot be null");
        this.authenticationRequestFactory = authenticationRequestFactory;
    }

    public void setRedirectMatcher(RequestMatcher redirectMatcher) {
        Assert.notNull((Object)redirectMatcher, (String)"redirectMatcher cannot be null");
        this.redirectMatcher = redirectMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestMatcher.MatchResult matcher = this.redirectMatcher.matcher(request);
        if (!matcher.isMatch()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String registrationId = (String)matcher.getVariables().get("registrationId");
        this.sendRedirect(request, response, registrationId);
    }

    private void sendRedirect(HttpServletRequest request, HttpServletResponse response, String registrationId) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Creating SAML2 SP Authentication Request for IDP[%s]", registrationId));
        }
        RelyingPartyRegistration relyingParty = this.relyingPartyRegistrationRepository.findByRegistrationId(registrationId);
        String redirectUrl = this.createSamlRequestRedirectUrl(request, relyingParty);
        response.sendRedirect(redirectUrl);
    }

    private String createSamlRequestRedirectUrl(HttpServletRequest request, RelyingPartyRegistration relyingParty) {
        Saml2AuthenticationRequest authNRequest = this.createAuthenticationRequest(relyingParty, request);
        String xml = this.authenticationRequestFactory.createAuthenticationRequest(authNRequest);
        String encoded = Saml2Utils.encode(Saml2Utils.deflate(xml));
        String relayState = request.getParameter("RelayState");
        String redirect = UriComponentsBuilder.fromUriString((String)relyingParty.getIdpWebSsoUrl()).queryParam("SAMLRequest", new Object[]{UriUtils.encode((String)encoded, (Charset)StandardCharsets.ISO_8859_1)}).queryParam("RelayState", new Object[]{UriUtils.encode((String)relayState, (Charset)StandardCharsets.ISO_8859_1)}).build(true).toUriString();
        return redirect;
    }

    private Saml2AuthenticationRequest createAuthenticationRequest(RelyingPartyRegistration relyingParty, HttpServletRequest request) {
        String localSpEntityId = Saml2Utils.getServiceProviderEntityId(relyingParty, request);
        return Saml2AuthenticationRequest.builder().issuer(localSpEntityId).destination(relyingParty.getIdpWebSsoUrl()).credentials(c -> c.addAll(relyingParty.getCredentials())).assertionConsumerServiceUrl(Saml2Utils.resolveUrlTemplate(relyingParty.getAssertionConsumerServiceUrlTemplate(), Saml2Utils.getApplicationUri(request), relyingParty.getRemoteIdpEntityId(), relyingParty.getRegistrationId())).build();
    }
}

