/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.impl.EvaluableProtocolRoleDescriptorCriterion;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableEntityIDCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableUsageCredentialCriterion;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlImplementation;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.authentication.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.SimpleSaml2AuthenticatedPrincipal;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OpenSamlAuthenticationProvider
implements AuthenticationProvider {
    private static Log logger = LogFactory.getLog(OpenSamlAuthenticationProvider.class);
    private final List<ConditionValidator> conditions = Collections.singletonList(new AudienceRestrictionConditionValidator());
    private final SubjectConfirmationValidator subjectConfirmationValidator = new BearerSubjectConfirmationValidator(){

        @Nonnull
        protected ValidationResult validateAddress(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) {
            return ValidationResult.VALID;
        }
    };
    private final List<SubjectConfirmationValidator> subjects = Collections.singletonList(this.subjectConfirmationValidator);
    private final List<StatementValidator> statements = Collections.emptyList();
    private final SignaturePrevalidator signaturePrevalidator = new SAMLSignatureProfileValidator();
    private final OpenSamlImplementation saml = OpenSamlImplementation.getInstance();
    private Converter<Assertion, Collection<? extends GrantedAuthority>> authoritiesExtractor = a -> Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER"));
    private GrantedAuthoritiesMapper authoritiesMapper = a -> a;
    private Duration responseTimeValidationSkew = Duration.ofMinutes(5L);

    public void setAuthoritiesExtractor(Converter<Assertion, Collection<? extends GrantedAuthority>> authoritiesExtractor) {
        Assert.notNull(authoritiesExtractor, (String)"authoritiesExtractor cannot be null");
        this.authoritiesExtractor = authoritiesExtractor;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        Assert.notNull((Object)authoritiesMapper, (String)"authoritiesMapper cannot be null");
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setResponseTimeValidationSkew(Duration responseTimeValidationSkew) {
        this.responseTimeValidationSkew = responseTimeValidationSkew;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Saml2AuthenticationToken token = (Saml2AuthenticationToken)authentication;
            Response response = this.parse(token.getSaml2Response());
            List<Assertion> validAssertions = this.validateResponse(token, response);
            Assertion assertion = validAssertions.get(0);
            String username = this.getUsername(token, assertion);
            return new Saml2Authentication(new SimpleSaml2AuthenticatedPrincipal(username), token.getSaml2Response(), this.authoritiesMapper.mapAuthorities(this.getAssertionAuthorities(assertion)));
        }
        catch (Saml2AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.authException("internal_validation_error", e.getMessage(), e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Collection<? extends GrantedAuthority> getAssertionAuthorities(Assertion assertion) {
        return (Collection)this.authoritiesExtractor.convert((Object)assertion);
    }

    private Response parse(String response) throws Saml2Exception, Saml2AuthenticationException {
        try {
            XMLObject result = this.saml.resolve(response);
            if (result instanceof Response) {
                return (Response)result;
            }
            throw this.authException("unknown_response_class", "Invalid response class:" + result.getClass().getName());
        }
        catch (Saml2Exception x) {
            throw this.authException("malformed_response_data", x.getMessage(), x);
        }
    }

    private List<Assertion> validateResponse(Saml2AuthenticationToken token, Response response) throws Saml2AuthenticationException {
        String message;
        String destination;
        ArrayList<Assertion> validAssertions = new ArrayList<Assertion>();
        String issuer = response.getIssuer().getValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating SAML response from " + issuer));
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>(response.getAssertions());
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            Assertion assertion = this.decrypt(token, encryptedAssertion);
            assertions.add(assertion);
        }
        if (assertions.isEmpty()) {
            throw this.authException("malformed_response_data", "No assertions found in response.");
        }
        if (!this.isSigned(response, assertions)) {
            throw this.authException("invalid_signature", "Either the response or one of the assertions is unsigned. Please either sign the response or all of the assertions.");
        }
        SignatureTrustEngine signatureTrustEngine = this.buildSignatureTrustEngine(token);
        HashMap<String, Saml2AuthenticationException> validationExceptions = new HashMap<String, Saml2AuthenticationException>();
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            try {
                profileValidator.validate(response.getSignature());
            }
            catch (Exception e) {
                validationExceptions.put("invalid_signature", this.authException("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]", e));
            }
            try {
                CriteriaSet criteriaSet = new CriteriaSet();
                criteriaSet.add((Object)new EvaluableEntityIDCredentialCriterion(new EntityIdCriterion(issuer)));
                criteriaSet.add((Object)new EvaluableProtocolRoleDescriptorCriterion(new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")));
                criteriaSet.add((Object)new EvaluableUsageCredentialCriterion(new UsageCriterion(UsageType.SIGNING)));
                if (!signatureTrustEngine.validate((Object)response.getSignature(), criteriaSet)) {
                    validationExceptions.put("invalid_signature", this.authException("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]"));
                }
            }
            catch (Exception e) {
                validationExceptions.put("invalid_signature", this.authException("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]", e));
            }
        }
        if (StringUtils.hasText((String)(destination = response.getDestination())) && !destination.equals(token.getRecipientUri())) {
            message = "Invalid destination [" + destination + "] for SAML response [" + response.getID() + "]";
            validationExceptions.put("invalid_destination", this.authException("invalid_destination", message));
        }
        if (!StringUtils.hasText((String)issuer) || !issuer.equals(token.getIdpEntityId())) {
            message = String.format("Invalid issuer [%s] for SAML response [%s]", issuer, response.getID());
            validationExceptions.put("invalid_issuer", this.authException("invalid_issuer", message));
        }
        SAML20AssertionValidator validator = this.buildSamlAssertionValidator(signatureTrustEngine);
        ValidationContext context = this.buildValidationContext(token, response);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating " + assertions.size() + " assertions"));
        }
        for (Assertion assertion : assertions) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Validating assertion " + assertion.getID()));
            }
            try {
                validAssertions.add(this.validateAssertion(assertion, validator, context));
            }
            catch (Exception e) {
                String message2 = String.format("Invalid assertion [%s] for SAML response [%s]", assertion.getID(), response.getID());
                validationExceptions.put("invalid_assertion", this.authException("invalid_assertion", message2, e));
            }
        }
        if (validationExceptions.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully validated SAML Response [" + response.getID() + "]"));
            }
        } else if (logger.isTraceEnabled()) {
            logger.debug((Object)("Found " + validationExceptions.size() + " validation errors in SAML response [" + response.getID() + "]: " + validationExceptions.values()));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + validationExceptions.size() + " validation errors in SAML response [" + response.getID() + "]"));
        }
        if (!validationExceptions.isEmpty()) {
            throw (Saml2AuthenticationException)((Object)validationExceptions.values().iterator().next());
        }
        if (validAssertions.isEmpty()) {
            throw this.authException("malformed_response_data", "No valid assertions found in response.");
        }
        return validAssertions;
    }

    private boolean isSigned(Response samlResponse, List<Assertion> assertions) {
        if (samlResponse.isSigned()) {
            return true;
        }
        for (Assertion assertion : assertions) {
            if (assertion.isSigned()) continue;
            return false;
        }
        return true;
    }

    private SignatureTrustEngine buildSignatureTrustEngine(Saml2AuthenticationToken token) {
        HashSet<BasicX509Credential> credentials = new HashSet<BasicX509Credential>();
        for (X509Certificate key : this.getVerificationCertificates(token)) {
            BasicX509Credential cred = new BasicX509Credential(key);
            cred.setUsageType(UsageType.SIGNING);
            cred.setEntityId(token.getIdpEntityId());
            credentials.add(cred);
        }
        CollectionCredentialResolver credentialsResolver = new CollectionCredentialResolver(credentials);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialsResolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
    }

    private ValidationContext buildValidationContext(Saml2AuthenticationToken token, Response response) {
        HashMap<String, Object> validationParams = new HashMap<String, Object>();
        validationParams.put("saml2.SignatureRequired", !response.isSigned());
        validationParams.put("saml2.ClockSkew", this.responseTimeValidationSkew.toMillis());
        validationParams.put("saml2.Conditions.ValidAudiences", Collections.singleton(token.getLocalSpEntityId()));
        if (StringUtils.hasText((String)token.getRecipientUri())) {
            validationParams.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(token.getRecipientUri()));
        }
        return new ValidationContext(validationParams);
    }

    private SAML20AssertionValidator buildSamlAssertionValidator(SignatureTrustEngine signatureTrustEngine) {
        return new SAML20AssertionValidator(this.conditions, this.subjects, this.statements, signatureTrustEngine, this.signaturePrevalidator);
    }

    private Assertion validateAssertion(Assertion assertion, SAML20AssertionValidator validator, ValidationContext context) {
        ValidationResult result;
        try {
            result = validator.validate(assertion, context);
        }
        catch (Exception e) {
            throw new Saml2Exception("An error occurred while validation the assertion", e);
        }
        if (result != ValidationResult.VALID) {
            throw new Saml2Exception("An error occurred while validating the assertion: " + context.getValidationFailureMessage());
        }
        return assertion;
    }

    private Assertion decrypt(Saml2AuthenticationToken token, EncryptedAssertion assertion) throws Saml2AuthenticationException {
        Saml2AuthenticationException last = null;
        List<Saml2X509Credential> decryptionCredentials = this.getDecryptionCredentials(token);
        if (decryptionCredentials.isEmpty()) {
            throw this.authException("decryption_error", "No valid decryption credentials found.");
        }
        for (Saml2X509Credential key : decryptionCredentials) {
            Decrypter decrypter = this.getDecrypter(key);
            try {
                return decrypter.decrypt(assertion);
            }
            catch (DecryptionException e) {
                last = this.authException("decryption_error", e.getMessage(), (Exception)((Object)e));
            }
        }
        throw last;
    }

    private Decrypter getDecrypter(Saml2X509Credential key) {
        BasicX509Credential credential = CredentialSupport.getSimpleCredential((X509Certificate)key.getCertificate(), (PrivateKey)key.getPrivateKey());
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver((Credential)credential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, this.saml.getEncryptedKeyResolver());
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    private List<Saml2X509Credential> getDecryptionCredentials(Saml2AuthenticationToken token) {
        LinkedList<Saml2X509Credential> result = new LinkedList<Saml2X509Credential>();
        for (Saml2X509Credential c : token.getX509Credentials()) {
            if (!c.isDecryptionCredential()) continue;
            result.add(c);
        }
        return result;
    }

    private List<X509Certificate> getVerificationCertificates(Saml2AuthenticationToken token) {
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        for (Saml2X509Credential c : token.getX509Credentials()) {
            if (!c.isSignatureVerficationCredential()) continue;
            result.add(c.getCertificate());
        }
        return result;
    }

    private String getUsername(Saml2AuthenticationToken token, Assertion assertion) throws Saml2AuthenticationException {
        String username = null;
        Subject subject = assertion.getSubject();
        if (subject == null) {
            throw this.authException("subject_not_found", "Assertion [" + assertion.getID() + "] is missing a subject");
        }
        if (subject.getNameID() != null) {
            username = subject.getNameID().getValue();
        } else if (subject.getEncryptedID() != null) {
            NameID nameId = this.decrypt(token, subject.getEncryptedID());
            username = nameId.getValue();
        }
        if (username == null) {
            throw this.authException("username_not_found", "Assertion [" + assertion.getID() + "] is missing a user identifier");
        }
        return username;
    }

    private NameID decrypt(Saml2AuthenticationToken token, EncryptedID assertion) throws Saml2AuthenticationException {
        Saml2AuthenticationException last = null;
        List<Saml2X509Credential> decryptionCredentials = this.getDecryptionCredentials(token);
        if (decryptionCredentials.isEmpty()) {
            throw this.authException("decryption_error", "No valid decryption credentials found.");
        }
        for (Saml2X509Credential key : decryptionCredentials) {
            Decrypter decrypter = this.getDecrypter(key);
            try {
                return (NameID)decrypter.decrypt(assertion);
            }
            catch (DecryptionException e) {
                last = this.authException("decryption_error", e.getMessage(), (Exception)((Object)e));
            }
        }
        throw last;
    }

    private Saml2Error validationError(String code, String description) {
        return new Saml2Error(code, description);
    }

    private Saml2AuthenticationException authException(String code, String description) throws Saml2AuthenticationException {
        return new Saml2AuthenticationException(this.validationError(code, description));
    }

    private Saml2AuthenticationException authException(String code, String description, Exception cause) throws Saml2AuthenticationException {
        return new Saml2AuthenticationException(this.validationError(code, description), cause);
    }
}

