/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.util.Assert;

@Deprecated
public final class Saml2AuthenticationRequest {
    private final String issuer;
    private final List<Saml2X509Credential> credentials;
    private final String destination;
    private final String assertionConsumerServiceUrl;

    private Saml2AuthenticationRequest(String issuer, String destination, String assertionConsumerServiceUrl, List<Saml2X509Credential> credentials) {
        Assert.hasText((String)issuer, (String)"issuer cannot be null");
        Assert.hasText((String)destination, (String)"destination cannot be null");
        Assert.hasText((String)assertionConsumerServiceUrl, (String)"spAssertionConsumerServiceUrl cannot be null");
        this.issuer = issuer;
        this.destination = destination;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.credentials = new LinkedList<Saml2X509Credential>();
        for (Saml2X509Credential c : credentials) {
            if (!c.isSigningCredential()) continue;
            this.credentials.add(c);
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    public List<Saml2X509Credential> getCredentials() {
        return this.credentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withAuthenticationRequestContext(Saml2AuthenticationRequestContext context) {
        return new Builder().assertionConsumerServiceUrl(context.getAssertionConsumerServiceUrl()).issuer(context.getIssuer()).destination(context.getDestination()).credentials(c -> c.addAll(context.getRelyingPartyRegistration().getCredentials()));
    }

    public static class Builder {
        private String issuer;
        private List<Saml2X509Credential> credentials = new LinkedList<Saml2X509Credential>();
        private String destination;
        private String assertionConsumerServiceUrl;

        private Builder() {
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder credentials(Consumer<Collection<Saml2X509Credential>> credentials) {
            credentials.accept(this.credentials);
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public Builder assertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
            return this;
        }

        public Saml2AuthenticationRequest build() {
            return new Saml2AuthenticationRequest(this.issuer, this.destination, this.assertionConsumerServiceUrl, this.credentials);
        }
    }
}

