/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class Saml2ServletUtils {
    private static final char PATH_DELIMITER = '/';

    private Saml2ServletUtils() {
    }

    static String resolveUrlTemplate(String template, String baseUrl, RelyingPartyRegistration relyingParty) {
        if (!StringUtils.hasText((String)template)) {
            return baseUrl;
        }
        String entityId = relyingParty.getAssertingPartyDetails().getEntityId();
        String registrationId = relyingParty.getRegistrationId();
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseUrl).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port != -1 ? ":" + port : "");
        String path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        uriVariables.put("basePath", path != null ? path : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("entityId", StringUtils.hasText((String)entityId) ? entityId : "");
        uriVariables.put("registrationId", StringUtils.hasText((String)registrationId) ? registrationId : "");
        return UriComponentsBuilder.fromUriString((String)template).buildAndExpand(uriVariables).toUriString();
    }

    static String getApplicationUri(HttpServletRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return uriComponents.toUriString();
    }
}

