/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class Saml2AuthenticationTokenConverter
implements AuthenticationConverter {
    private static Base64 BASE64 = new Base64(0, new byte[]{10});
    private final Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver;

    public Saml2AuthenticationTokenConverter(Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver) {
        Assert.notNull(relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        RelyingPartyRegistration relyingPartyRegistration = (RelyingPartyRegistration)this.relyingPartyRegistrationResolver.convert((Object)request);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String saml2Response = request.getParameter("SAMLResponse");
        if (saml2Response == null) {
            return null;
        }
        byte[] b = this.samlDecode(saml2Response);
        saml2Response = this.inflateIfRequired(request, b);
        return new Saml2AuthenticationToken(relyingPartyRegistration, saml2Response);
    }

    private String inflateIfRequired(HttpServletRequest request, byte[] b) {
        if (HttpMethod.GET.matches(request.getMethod())) {
            return this.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private byte[] samlDecode(String s) {
        return BASE64.decode(s);
    }

    private String samlInflate(byte[] b) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(out, new Inflater(true));
            inflaterOutputStream.write(b);
            inflaterOutputStream.finish();
            return new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new Saml2Exception("Unable to inflate string", ex);
        }
    }
}

