/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public class Saml2PostAuthenticationRequest
extends AbstractSaml2AuthenticationRequest {
    Saml2PostAuthenticationRequest(String samlRequest, String relayState, String authenticationRequestUri) {
        super(samlRequest, relayState, authenticationRequestUri);
    }

    @Override
    public Saml2MessageBinding getBinding() {
        return Saml2MessageBinding.POST;
    }

    public static Builder withAuthenticationRequestContext(Saml2AuthenticationRequestContext context) {
        return (Builder)((Builder)new Builder().authenticationRequestUri(context.getDestination())).relayState(context.getRelayState());
    }

    public static final class Builder
    extends AbstractSaml2AuthenticationRequest.Builder<Builder> {
        private Builder() {
        }

        public Saml2PostAuthenticationRequest build() {
            return new Saml2PostAuthenticationRequest(this.samlRequest, this.relayState, this.authenticationRequestUri);
        }
    }
}

