/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSamlSigningUtils;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2Utils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class OpenSamlAuthenticationRequestResolver {
    private final RequestMatcher requestMatcher = new AntPathRequestMatcher("/saml2/authenticate/{registrationId}");
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private final AuthnRequestBuilder authnRequestBuilder;
    private final AuthnRequestMarshaller marshaller;
    private final IssuerBuilder issuerBuilder;
    private final NameIDBuilder nameIdBuilder;

    OpenSamlAuthenticationRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.marshaller = (AuthnRequestMarshaller)registry.getMarshallerFactory().getMarshaller(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"logoutRequestMarshaller must be configured in OpenSAML");
        this.authnRequestBuilder = (AuthnRequestBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.authnRequestBuilder, (String)"authnRequestBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.nameIdBuilder = (NameIDBuilder)registry.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.nameIdBuilder, (String)"nameIdBuilder must be configured in OpenSAML");
    }

    <T extends AbstractSaml2AuthenticationRequest> T resolve(HttpServletRequest request) {
        return this.resolve(request, (registration, logoutRequest) -> {});
    }

    <T extends AbstractSaml2AuthenticationRequest> T resolve(HttpServletRequest request, BiConsumer<RelyingPartyRegistration, AuthnRequest> authnRequestConsumer) {
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        String registrationId = (String)result.getVariables().get("registrationId");
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null) {
            return null;
        }
        AuthnRequest authnRequest = this.authnRequestBuilder.buildObject();
        authnRequest.setForceAuthn(Boolean.FALSE);
        authnRequest.setIsPassive(Boolean.FALSE);
        authnRequest.setProtocolBinding(registration.getAssertionConsumerServiceBinding().getUrn());
        Issuer iss = this.issuerBuilder.buildObject();
        iss.setValue(registration.getEntityId());
        authnRequest.setIssuer(iss);
        authnRequest.setDestination(registration.getAssertingPartyDetails().getSingleSignOnServiceLocation());
        authnRequest.setAssertionConsumerServiceURL(registration.getAssertionConsumerServiceLocation());
        authnRequestConsumer.accept(registration, authnRequest);
        if (authnRequest.getID() == null) {
            authnRequest.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        }
        String relayState = UUID.randomUUID().toString();
        Saml2MessageBinding binding = registration.getAssertingPartyDetails().getSingleSignOnServiceBinding();
        if (binding == Saml2MessageBinding.POST) {
            if (registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()) {
                OpenSamlSigningUtils.sign(authnRequest, registration);
            }
            String xml = this.serialize(authnRequest);
            String encoded = Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8));
            return (T)((Saml2PostAuthenticationRequest.Builder)((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withRelyingPartyRegistration(registration).samlRequest(encoded)).relayState(relayState)).build();
        }
        String xml = this.serialize(authnRequest);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        Saml2RedirectAuthenticationRequest.Builder builder = (Saml2RedirectAuthenticationRequest.Builder)((Saml2RedirectAuthenticationRequest.Builder)Saml2RedirectAuthenticationRequest.withRelyingPartyRegistration(registration).samlRequest(deflatedAndEncoded)).relayState(relayState);
        if (registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()) {
            Map<String, String> parameters = OpenSamlSigningUtils.sign(registration).param("SAMLRequest", deflatedAndEncoded).param("RelayState", relayState).parameters();
            builder.sigAlg(parameters.get("SigAlg")).signature(parameters.get("Signature"));
        }
        return (T)builder.build();
    }

    private String serialize(AuthnRequest authnRequest) {
        try {
            Element element = this.marshaller.marshall((XMLObject)authnRequest);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

