/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.OpenSamlMetadataRelyingPartyRegistrationConverter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

public final class RelyingPartyRegistrations {
    private static final OpenSamlMetadataRelyingPartyRegistrationConverter relyingPartyRegistrationConverter = new OpenSamlMetadataRelyingPartyRegistrationConverter();
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();

    private RelyingPartyRegistrations() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RelyingPartyRegistration.Builder fromMetadataLocation(String metadataLocation) {
        try (InputStream source = resourceLoader.getResource(metadataLocation).getInputStream();){
            RelyingPartyRegistration.Builder builder = RelyingPartyRegistrations.fromMetadata(source);
            return builder;
        }
        catch (IOException ex) {
            if (!(ex.getCause() instanceof Saml2Exception)) throw new Saml2Exception(ex);
            throw (Saml2Exception)ex.getCause();
        }
    }

    public static RelyingPartyRegistration.Builder fromMetadata(InputStream source) {
        return RelyingPartyRegistrations.collectionFromMetadata(source).iterator().next();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<RelyingPartyRegistration.Builder> collectionFromMetadataLocation(String location) {
        try (InputStream source = resourceLoader.getResource(location).getInputStream();){
            Collection<RelyingPartyRegistration.Builder> collection = RelyingPartyRegistrations.collectionFromMetadata(source);
            return collection;
        }
        catch (IOException ex) {
            if (!(ex.getCause() instanceof Saml2Exception)) throw new Saml2Exception(ex);
            throw (Saml2Exception)ex.getCause();
        }
    }

    public static Collection<RelyingPartyRegistration.Builder> collectionFromMetadata(InputStream source) {
        return relyingPartyRegistrationConverter.convert(source);
    }
}

