/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class Saml2RelyingPartyInitiatedLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Saml2LogoutRequestResolver logoutRequestResolver;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private Saml2LogoutRequestRepository logoutRequestRepository = new HttpSessionLogoutRequestRepository();

    public Saml2RelyingPartyInitiatedLogoutSuccessHandler(Saml2LogoutRequestResolver logoutRequestResolver) {
        this.logoutRequestResolver = logoutRequestResolver;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Saml2LogoutRequest logoutRequest = this.logoutRequestResolver.resolve(request, authentication);
        if (logoutRequest == null) {
            this.logger.trace((Object)"Returning 401 since no logout request generated");
            response.setStatus(401);
            return;
        }
        this.logoutRequestRepository.saveLogoutRequest(logoutRequest, request, response);
        if (logoutRequest.getBinding() == Saml2MessageBinding.REDIRECT) {
            this.doRedirect(request, response, logoutRequest);
        } else {
            this.doPost(response, logoutRequest);
        }
    }

    public void setLogoutRequestRepository(Saml2LogoutRequestRepository logoutRequestRepository) {
        Assert.notNull((Object)logoutRequestRepository, (String)"logoutRequestRepository cannot be null");
        this.logoutRequestRepository = logoutRequestRepository;
    }

    private void doRedirect(HttpServletRequest request, HttpServletResponse response, Saml2LogoutRequest logoutRequest) throws IOException {
        String location = logoutRequest.getLocation();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)location).query(logoutRequest.getParametersQuery());
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.build(true).toUriString());
    }

    private void doPost(HttpServletResponse response, Saml2LogoutRequest logoutRequest) throws IOException {
        String location = logoutRequest.getLocation();
        String saml = logoutRequest.getSamlRequest();
        String relayState = logoutRequest.getRelayState();
        String html = this.createSamlPostRequestFormData(location, saml, relayState);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlPostRequestFormData(String location, String saml, String relayState) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n").append("    <head>\n");
        html.append("        <meta http-equiv=\"Content-Security-Policy\" ").append("content=\"script-src 'sha256-t+jmhLjs1ocvgaHBJsFcgznRk68d37TLtbI3NE9h7EU='\">\n");
        html.append("        <meta charset=\"utf-8\" />\n");
        html.append("    </head>\n");
        html.append("    <body onload=\"document.forms[0].submit()\">\n");
        html.append("        <noscript>\n");
        html.append("            <p>\n");
        html.append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n");
        html.append("                you must press the Continue button once to proceed.\n");
        html.append("            </p>\n");
        html.append("        </noscript>\n");
        html.append("        \n");
        html.append("        <form action=\"");
        html.append(location);
        html.append("\" method=\"post\">\n");
        html.append("            <div>\n");
        html.append("                <input type=\"hidden\" name=\"SAMLRequest\" value=\"");
        html.append(HtmlUtils.htmlEscape((String)saml));
        html.append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            html.append("                <input type=\"hidden\" name=\"RelayState\" value=\"");
            html.append(HtmlUtils.htmlEscape((String)relayState));
            html.append("\"/>\n");
        }
        html.append("            </div>\n");
        html.append("            <noscript>\n");
        html.append("                <div>\n");
        html.append("                    <input type=\"submit\" value=\"Continue\"/>\n");
        html.append("                </div>\n");
        html.append("            </noscript>\n");
        html.append("        </form>\n");
        html.append("        \n");
        html.append("    </body>\n");
        html.append("    <script>window.onload = () => document.forms[0].submit();</script>\n");
        html.append("</html>");
        return html.toString();
    }
}

