/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public interface AssertingPartyMetadata {
    public String getEntityId();

    public boolean getWantAuthnRequestsSigned();

    public List<String> getSigningAlgorithms();

    public Collection<Saml2X509Credential> getVerificationX509Credentials();

    public Collection<Saml2X509Credential> getEncryptionX509Credentials();

    public String getSingleSignOnServiceLocation();

    public Saml2MessageBinding getSingleSignOnServiceBinding();

    public String getSingleLogoutServiceLocation();

    public String getSingleLogoutServiceResponseLocation();

    public Saml2MessageBinding getSingleLogoutServiceBinding();

    public Builder<?> mutate();

    public static interface Builder<B extends Builder<B>> {
        public B entityId(String var1);

        public B wantAuthnRequestsSigned(boolean var1);

        public B signingAlgorithms(Consumer<List<String>> var1);

        public B verificationX509Credentials(Consumer<Collection<Saml2X509Credential>> var1);

        public B encryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> var1);

        public B singleSignOnServiceLocation(String var1);

        public B singleSignOnServiceBinding(Saml2MessageBinding var1);

        public B singleLogoutServiceLocation(String var1);

        public B singleLogoutServiceResponseLocation(String var1);

        public B singleLogoutServiceBinding(Saml2MessageBinding var1);

        public AssertingPartyMetadata build();
    }
}

