/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.MetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadataRepository;
import org.springframework.security.saml2.provider.service.registration.OpenSamlAssertingPartyDetails;
import org.springframework.util.Assert;

class BaseOpenSamlAssertingPartyMetadataRepository
implements AssertingPartyMetadataRepository {
    private final MetadataResolverAdapter metadataResolver;
    private final Supplier<Iterator<EntityDescriptor>> descriptors;

    BaseOpenSamlAssertingPartyMetadataRepository(MetadataResolverAdapter metadataResolver) {
        Assert.notNull((Object)metadataResolver, (String)"metadataResolver cannot be null");
        if (BaseOpenSamlAssertingPartyMetadataRepository.isRoleIndexed(metadataResolver.metadataResolver)) {
            this.descriptors = this::allIndexedEntities;
        } else {
            MetadataResolver metadataResolver2 = metadataResolver.metadataResolver;
            if (metadataResolver2 instanceof IterableMetadataSource) {
                IterableMetadataSource source = (IterableMetadataSource)metadataResolver2;
                this.descriptors = () -> source.iterator();
            } else {
                throw new IllegalArgumentException("metadataResolver must be an IterableMetadataSource or have a RoleMetadataIndex");
            }
        }
        this.metadataResolver = metadataResolver;
    }

    private static boolean isRoleIndexed(MetadataResolver resolver) {
        if (!(resolver instanceof AbstractBatchMetadataResolver)) {
            return false;
        }
        AbstractBatchMetadataResolver batch = (AbstractBatchMetadataResolver)resolver;
        for (MetadataIndex index : batch.getIndexes()) {
            if (!(index instanceof RoleMetadataIndex)) continue;
            return true;
        }
        return false;
    }

    private Iterator<EntityDescriptor> allIndexedEntities() {
        EntityRoleCriterion idps = new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        try {
            return this.metadataResolver.resolve(idps).iterator();
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    @Override
    @NonNull
    public Iterator<AssertingPartyMetadata> iterator() {
        final Iterator<EntityDescriptor> descriptors = this.descriptors.get();
        return new Iterator<AssertingPartyMetadata>(){

            @Override
            public boolean hasNext() {
                return descriptors.hasNext();
            }

            @Override
            public AssertingPartyMetadata next() {
                return OpenSamlAssertingPartyDetails.withEntityDescriptor((EntityDescriptor)descriptors.next()).build();
            }
        };
    }

    @Override
    @Nullable
    public AssertingPartyMetadata findByEntityId(String entityId) {
        EntityDescriptor descriptor = this.resolveSingle(new EntityIdCriterion(entityId));
        if (descriptor == null) {
            return null;
        }
        return OpenSamlAssertingPartyDetails.withEntityDescriptor(descriptor).build();
    }

    private EntityDescriptor resolveSingle(EntityIdCriterion criterion) {
        try {
            return this.metadataResolver.resolveSingle(criterion);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    static MetadataResolver initialize(ResourceBackedMetadataResolver metadataResolver) {
        try {
            metadataResolver.setId(BaseOpenSamlAssertingPartyMetadataRepository.class.getName() + ".metadataResolver");
            metadataResolver.setIndexes(Set.of(new RoleMetadataIndex()));
            metadataResolver.initialize();
            return metadataResolver;
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    static abstract class MetadataResolverAdapter {
        final MetadataResolver metadataResolver;

        MetadataResolverAdapter(MetadataResolver metadataResolver) {
            this.metadataResolver = metadataResolver;
        }

        abstract EntityDescriptor resolveSingle(EntityIdCriterion var1) throws Exception;

        abstract Iterable<EntityDescriptor> resolve(EntityRoleCriterion var1) throws Exception;
    }
}

