/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.util.Assert;

public class Saml2AuthenticationException
extends AuthenticationException {
    private static final long serialVersionUID = -2996886630890949105L;
    private final Saml2Error error;

    public Saml2AuthenticationException(Saml2Error error) {
        this(error, error.getDescription());
    }

    public Saml2AuthenticationException(Saml2Error error, Throwable cause) {
        this(error, cause != null ? cause.getMessage() : error.getDescription(), cause);
    }

    public Saml2AuthenticationException(Saml2Error error, String message) {
        this(error, message, null);
    }

    public Saml2AuthenticationException(Saml2Error error, String message, Throwable cause) {
        super(message, cause);
        Assert.notNull((Object)error, (String)"error cannot be null");
        this.error = error;
    }

    public Saml2Error getSaml2Error() {
        return this.error;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Saml2AuthenticationException{");
        sb.append("error=").append(this.error);
        sb.append('}');
        return sb.toString();
    }
}

