/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2Utils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class Saml2AuthenticationTokenConverter
implements AuthenticationConverter {
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private Function<HttpServletRequest, AbstractSaml2AuthenticationRequest> loader;

    public Saml2AuthenticationTokenConverter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.loader = new HttpSessionSaml2AuthenticationRequestRepository()::loadAuthenticationRequest;
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        AbstractSaml2AuthenticationRequest authenticationRequest = this.loadAuthenticationRequest(request);
        String relyingPartyRegistrationId = authenticationRequest != null ? authenticationRequest.getRelyingPartyRegistrationId() : null;
        RelyingPartyRegistration relyingPartyRegistration = this.relyingPartyRegistrationResolver.resolve(request, relyingPartyRegistrationId);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String saml2Response = this.decode(request);
        if (saml2Response == null) {
            return null;
        }
        return new Saml2AuthenticationToken(relyingPartyRegistration, saml2Response, authenticationRequest);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.loader = authenticationRequestRepository::loadAuthenticationRequest;
    }

    private AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        return this.loader.apply(request);
    }

    private String decode(HttpServletRequest request) {
        String encoded = request.getParameter("SAMLResponse");
        if (encoded == null) {
            return null;
        }
        try {
            return Saml2Utils.withEncoded(encoded).requireBase64(true).inflate(HttpMethod.GET.matches(request.getMethod())).decode();
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", ex.getMessage()), ex);
        }
    }
}

