/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2Utils;
import org.springframework.web.util.UriComponentsBuilder;
import org.w3c.dom.Element;

interface OpenSamlOperations {
    public <T extends XMLObject> T build(QName var1);

    public <T extends XMLObject> T deserialize(String var1);

    public <T extends XMLObject> T deserialize(InputStream var1);

    public SerializationConfigurer<?> serialize(XMLObject var1);

    public SerializationConfigurer<?> serialize(Element var1);

    public SignatureConfigurer<?> withSigningKeys(Collection<Saml2X509Credential> var1);

    public VerificationConfigurer withVerificationKeys(Collection<Saml2X509Credential> var1);

    public DecryptionConfigurer withDecryptionKeys(Collection<Saml2X509Credential> var1);

    public static interface DecryptionConfigurer {
        public void decrypt(XMLObject var1);
    }

    public static interface VerificationConfigurer {
        public VerificationConfigurer entityId(String var1);

        public Collection<Saml2Error> verify(SignableXMLObject var1);

        public Collection<Saml2Error> verify(RedirectParameters var1);

        public static final class RedirectParameters {
            private final String id;
            private final Issuer issuer;
            private final String algorithm;
            private final byte[] signature;
            private final byte[] content;

            RedirectParameters(Map<String, String> parameters, String parametersQuery, RequestAbstractType request) {
                this.id = request.getID();
                this.issuer = request.getIssuer();
                this.algorithm = parameters.get("SigAlg");
                this.signature = (byte[])(parameters.get("Signature") != null ? Saml2Utils.samlDecode(parameters.get("Signature")) : null);
                Map queryParams = UriComponentsBuilder.newInstance().query(parametersQuery).build(true).getQueryParams().toSingleValueMap();
                String relayState = parameters.get("RelayState");
                this.content = RedirectParameters.getContent("SAMLRequest", relayState, queryParams);
            }

            RedirectParameters(Map<String, String> parameters, String parametersQuery, StatusResponseType response) {
                this.id = response.getID();
                this.issuer = response.getIssuer();
                this.algorithm = parameters.get("SigAlg");
                this.signature = (byte[])(parameters.get("Signature") != null ? Saml2Utils.samlDecode(parameters.get("Signature")) : null);
                Map queryParams = UriComponentsBuilder.newInstance().query(parametersQuery).build(true).getQueryParams().toSingleValueMap();
                String relayState = parameters.get("RelayState");
                this.content = RedirectParameters.getContent("SAMLResponse", relayState, queryParams);
            }

            static byte[] getContent(String samlObject, String relayState, Map<String, String> queryParams) {
                if (Objects.nonNull(relayState)) {
                    return String.format("%s=%s&%s=%s&%s=%s", samlObject, queryParams.get(samlObject), "RelayState", queryParams.get("RelayState"), "SigAlg", queryParams.get("SigAlg")).getBytes(StandardCharsets.UTF_8);
                }
                return String.format("%s=%s&%s=%s", samlObject, queryParams.get(samlObject), "SigAlg", queryParams.get("SigAlg")).getBytes(StandardCharsets.UTF_8);
            }

            String getId() {
                return this.id;
            }

            Issuer getIssuer() {
                return this.issuer;
            }

            byte[] getContent() {
                return this.content;
            }

            String getAlgorithm() {
                return this.algorithm;
            }

            byte[] getSignature() {
                return this.signature;
            }

            boolean hasSignature() {
                return this.signature != null;
            }
        }
    }

    public static interface SignatureConfigurer<B extends SignatureConfigurer<B>> {
        public B algorithms(List<String> var1);

        public <O extends SignableXMLObject> O sign(O var1);

        public Map<String, String> sign(Map<String, String> var1);
    }

    public static interface SerializationConfigurer<B extends SerializationConfigurer<B>> {
        public B prettyPrint(boolean var1);

        public String serialize();
    }
}

