/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RelyingPartyRegistration
implements Serializable {
    private static final long serialVersionUID = -2718908121120942813L;
    private final String registrationId;
    private final String entityId;
    private final String assertionConsumerServiceLocation;
    private final Saml2MessageBinding assertionConsumerServiceBinding;
    private final String singleLogoutServiceLocation;
    private final String singleLogoutServiceResponseLocation;
    private final Collection<Saml2MessageBinding> singleLogoutServiceBindings;
    private final String nameIdFormat;
    private final boolean authnRequestsSigned;
    private final AssertingPartyMetadata assertingPartyMetadata;
    private final Collection<Saml2X509Credential> decryptionX509Credentials;
    private final Collection<Saml2X509Credential> signingX509Credentials;

    protected RelyingPartyRegistration(String registrationId, String entityId, String assertionConsumerServiceLocation, Saml2MessageBinding assertionConsumerServiceBinding, String singleLogoutServiceLocation, String singleLogoutServiceResponseLocation, Collection<Saml2MessageBinding> singleLogoutServiceBindings, AssertingPartyDetails assertingPartyDetails, String nameIdFormat, boolean authnRequestsSigned, Collection<Saml2X509Credential> decryptionX509Credentials, Collection<Saml2X509Credential> signingX509Credentials) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        Assert.hasText((String)entityId, (String)"entityId cannot be empty");
        Assert.hasText((String)assertionConsumerServiceLocation, (String)"assertionConsumerServiceLocation cannot be empty");
        Assert.notNull((Object)((Object)assertionConsumerServiceBinding), (String)"assertionConsumerServiceBinding cannot be null");
        Assert.isTrue((singleLogoutServiceLocation == null || !CollectionUtils.isEmpty(singleLogoutServiceBindings) ? 1 : 0) != 0, (String)"singleLogoutServiceBindings cannot be null or empty when singleLogoutServiceLocation is set");
        Assert.notNull((Object)assertingPartyDetails, (String)"assertingPartyDetails cannot be null");
        Assert.notNull(decryptionX509Credentials, (String)"decryptionX509Credentials cannot be null");
        for (Saml2X509Credential c : decryptionX509Credentials) {
            Assert.notNull((Object)c, (String)"decryptionX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)c.isDecryptionCredential(), (String)"All decryptionX509Credentials must have a usage of DECRYPTION set");
        }
        Assert.notNull(signingX509Credentials, (String)"signingX509Credentials cannot be null");
        for (Saml2X509Credential c : signingX509Credentials) {
            Assert.notNull((Object)c, (String)"signingX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)c.isSigningCredential(), (String)"All signingX509Credentials must have a usage of SIGNING set");
        }
        this.registrationId = registrationId;
        this.entityId = entityId;
        this.assertionConsumerServiceLocation = assertionConsumerServiceLocation;
        this.assertionConsumerServiceBinding = assertionConsumerServiceBinding;
        this.singleLogoutServiceLocation = singleLogoutServiceLocation;
        this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
        this.singleLogoutServiceBindings = Collections.unmodifiableList(new LinkedList<Saml2MessageBinding>(singleLogoutServiceBindings));
        this.nameIdFormat = nameIdFormat;
        this.authnRequestsSigned = authnRequestsSigned;
        this.assertingPartyMetadata = assertingPartyDetails;
        this.decryptionX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(decryptionX509Credentials));
        this.signingX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(signingX509Credentials));
    }

    private RelyingPartyRegistration(String registrationId, String entityId, String assertionConsumerServiceLocation, Saml2MessageBinding assertionConsumerServiceBinding, String singleLogoutServiceLocation, String singleLogoutServiceResponseLocation, Collection<Saml2MessageBinding> singleLogoutServiceBindings, AssertingPartyMetadata assertingPartyMetadata, String nameIdFormat, boolean authnRequestsSigned, Collection<Saml2X509Credential> decryptionX509Credentials, Collection<Saml2X509Credential> signingX509Credentials) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        Assert.hasText((String)entityId, (String)"entityId cannot be empty");
        Assert.hasText((String)assertionConsumerServiceLocation, (String)"assertionConsumerServiceLocation cannot be empty");
        Assert.notNull((Object)((Object)assertionConsumerServiceBinding), (String)"assertionConsumerServiceBinding cannot be null");
        Assert.isTrue((singleLogoutServiceLocation == null || !CollectionUtils.isEmpty(singleLogoutServiceBindings) ? 1 : 0) != 0, (String)"singleLogoutServiceBindings cannot be null or empty when singleLogoutServiceLocation is set");
        Assert.notNull((Object)assertingPartyMetadata, (String)"assertingPartyDetails cannot be null");
        Assert.notNull(decryptionX509Credentials, (String)"decryptionX509Credentials cannot be null");
        for (Saml2X509Credential c : decryptionX509Credentials) {
            Assert.notNull((Object)c, (String)"decryptionX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)c.isDecryptionCredential(), (String)"All decryptionX509Credentials must have a usage of DECRYPTION set");
        }
        Assert.notNull(signingX509Credentials, (String)"signingX509Credentials cannot be null");
        for (Saml2X509Credential c : signingX509Credentials) {
            Assert.notNull((Object)c, (String)"signingX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)c.isSigningCredential(), (String)"All signingX509Credentials must have a usage of SIGNING set");
        }
        this.registrationId = registrationId;
        this.entityId = entityId;
        this.assertionConsumerServiceLocation = assertionConsumerServiceLocation;
        this.assertionConsumerServiceBinding = assertionConsumerServiceBinding;
        this.singleLogoutServiceLocation = singleLogoutServiceLocation;
        this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
        this.singleLogoutServiceBindings = Collections.unmodifiableList(new LinkedList<Saml2MessageBinding>(singleLogoutServiceBindings));
        this.nameIdFormat = nameIdFormat;
        this.authnRequestsSigned = authnRequestsSigned;
        this.assertingPartyMetadata = assertingPartyMetadata;
        this.decryptionX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(decryptionX509Credentials));
        this.signingX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(signingX509Credentials));
    }

    public Builder mutate() {
        return new Builder(this.registrationId, this.assertingPartyMetadata.mutate()).entityId(this.entityId).signingX509Credentials(c -> c.addAll(this.signingX509Credentials)).decryptionX509Credentials(c -> c.addAll(this.decryptionX509Credentials)).assertionConsumerServiceLocation(this.assertionConsumerServiceLocation).assertionConsumerServiceBinding(this.assertionConsumerServiceBinding).singleLogoutServiceLocation(this.singleLogoutServiceLocation).singleLogoutServiceResponseLocation(this.singleLogoutServiceResponseLocation).singleLogoutServiceBindings(c -> c.addAll(this.singleLogoutServiceBindings)).nameIdFormat(this.nameIdFormat).authnRequestsSigned(this.authnRequestsSigned);
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getAssertionConsumerServiceLocation() {
        return this.assertionConsumerServiceLocation;
    }

    public Saml2MessageBinding getAssertionConsumerServiceBinding() {
        return this.assertionConsumerServiceBinding;
    }

    public Saml2MessageBinding getSingleLogoutServiceBinding() {
        Assert.state((this.singleLogoutServiceBindings.size() == 1 ? 1 : 0) != 0, (String)"Method does not support multiple bindings.");
        return this.singleLogoutServiceBindings.iterator().next();
    }

    public Collection<Saml2MessageBinding> getSingleLogoutServiceBindings() {
        return this.singleLogoutServiceBindings;
    }

    public String getSingleLogoutServiceLocation() {
        return this.singleLogoutServiceLocation;
    }

    public String getSingleLogoutServiceResponseLocation() {
        return this.singleLogoutServiceResponseLocation;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    public Collection<Saml2X509Credential> getDecryptionX509Credentials() {
        return this.decryptionX509Credentials;
    }

    public Collection<Saml2X509Credential> getSigningX509Credentials() {
        return this.signingX509Credentials;
    }

    @Deprecated
    public AssertingPartyDetails getAssertingPartyDetails() {
        Assert.isInstanceOf(AssertingPartyDetails.class, (Object)this.assertingPartyMetadata, (String)"This class was initialized with an AssertingPartyMetadata, please call #getAssertingPartyMetadata instead");
        return (AssertingPartyDetails)this.assertingPartyMetadata;
    }

    public AssertingPartyMetadata getAssertingPartyMetadata() {
        return this.assertingPartyMetadata;
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId, new AssertingPartyDetails.Builder());
    }

    @Deprecated(forRemoval=true, since="6.4")
    public static Builder withAssertingPartyDetails(AssertingPartyDetails assertingPartyDetails) {
        Assert.notNull((Object)assertingPartyDetails, (String)"assertingPartyDetails cannot be null");
        return new Builder(assertingPartyDetails.getEntityId(), assertingPartyDetails.mutate());
    }

    public static Builder withAssertingPartyMetadata(AssertingPartyMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"assertingPartyMetadata cannot be null");
        return new Builder(metadata.getEntityId(), metadata.mutate());
    }

    @Deprecated(forRemoval=true, since="6.1")
    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        Assert.notNull((Object)registration, (String)"registration cannot be null");
        return RelyingPartyRegistration.withRegistrationId(registration.getRegistrationId()).entityId(registration.getEntityId()).signingX509Credentials(c -> c.addAll(registration.getSigningX509Credentials())).decryptionX509Credentials(c -> c.addAll(registration.getDecryptionX509Credentials())).assertionConsumerServiceLocation(registration.getAssertionConsumerServiceLocation()).assertionConsumerServiceBinding(registration.getAssertionConsumerServiceBinding()).singleLogoutServiceLocation(registration.getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(registration.getSingleLogoutServiceResponseLocation()).singleLogoutServiceBindings(c -> c.addAll(registration.getSingleLogoutServiceBindings())).nameIdFormat(registration.getNameIdFormat()).authnRequestsSigned(registration.isAuthnRequestsSigned()).assertingPartyDetails(assertingParty -> ((AssertingPartyDetails.Builder)((AssertingPartyDetails.Builder)((AssertingPartyDetails.Builder)assertingParty.entityId(registration.getAssertingPartyDetails().getEntityId()).wantAuthnRequestsSigned(registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()).signingAlgorithms(algorithms -> algorithms.addAll(registration.getAssertingPartyDetails().getSigningAlgorithms()))).verificationX509Credentials(c -> c.addAll(registration.getAssertingPartyDetails().getVerificationX509Credentials()))).encryptionX509Credentials(c -> c.addAll(registration.getAssertingPartyDetails().getEncryptionX509Credentials()))).singleSignOnServiceLocation(registration.getAssertingPartyDetails().getSingleSignOnServiceLocation()).singleSignOnServiceBinding(registration.getAssertingPartyDetails().getSingleSignOnServiceBinding()).singleLogoutServiceLocation(registration.getAssertingPartyDetails().getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation()).singleLogoutServiceBinding(registration.getAssertingPartyDetails().getSingleLogoutServiceBinding()));
    }

    public static class Builder {
        private String registrationId;
        private String entityId = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";
        private Collection<Saml2X509Credential> signingX509Credentials = new LinkedHashSet<Saml2X509Credential>();
        private Collection<Saml2X509Credential> decryptionX509Credentials = new LinkedHashSet<Saml2X509Credential>();
        private String assertionConsumerServiceLocation = "{baseUrl}/login/saml2/sso/{registrationId}";
        private Saml2MessageBinding assertionConsumerServiceBinding = Saml2MessageBinding.POST;
        private String singleLogoutServiceLocation;
        private String singleLogoutServiceResponseLocation;
        private Collection<Saml2MessageBinding> singleLogoutServiceBindings = new LinkedHashSet<Saml2MessageBinding>();
        private String nameIdFormat = null;
        private boolean authnRequestsSigned = false;
        private AssertingPartyMetadata.Builder<?> assertingPartyMetadataBuilder;

        protected Builder(String registrationId, AssertingPartyMetadata.Builder<?> assertingPartyMetadataBuilder) {
            this.registrationId = registrationId;
            this.assertingPartyMetadataBuilder = assertingPartyMetadataBuilder;
        }

        public Builder registrationId(String id) {
            this.registrationId = id;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder signingX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            credentialsConsumer.accept(this.signingX509Credentials);
            return this;
        }

        public Builder decryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            credentialsConsumer.accept(this.decryptionX509Credentials);
            return this;
        }

        public Builder assertionConsumerServiceLocation(String assertionConsumerServiceLocation) {
            this.assertionConsumerServiceLocation = assertionConsumerServiceLocation;
            return this;
        }

        public Builder assertionConsumerServiceBinding(Saml2MessageBinding assertionConsumerServiceBinding) {
            this.assertionConsumerServiceBinding = assertionConsumerServiceBinding;
            return this;
        }

        public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
            return this.singleLogoutServiceBindings(saml2MessageBindings -> {
                saml2MessageBindings.clear();
                saml2MessageBindings.add(singleLogoutServiceBinding);
            });
        }

        public Builder singleLogoutServiceBindings(Consumer<Collection<Saml2MessageBinding>> bindingsConsumer) {
            bindingsConsumer.accept(this.singleLogoutServiceBindings);
            return this;
        }

        public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
            this.singleLogoutServiceLocation = singleLogoutServiceLocation;
            return this;
        }

        public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
            this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
            return this;
        }

        public Builder nameIdFormat(String nameIdFormat) {
            this.nameIdFormat = nameIdFormat;
            return this;
        }

        public Builder authnRequestsSigned(Boolean authnRequestsSigned) {
            this.authnRequestsSigned = authnRequestsSigned;
            return this;
        }

        @Deprecated(forRemoval=true, since="6.4")
        public Builder assertingPartyDetails(Consumer<AssertingPartyDetails.Builder> assertingPartyDetails) {
            Assert.isInstanceOf(AssertingPartyDetails.Builder.class, this.assertingPartyMetadataBuilder, (String)"This class was constructed with an AssertingPartyMetadata instance, as such, please use #assertingPartyMetadata");
            assertingPartyDetails.accept((AssertingPartyDetails.Builder)this.assertingPartyMetadataBuilder);
            return this;
        }

        public Builder assertingPartyMetadata(Consumer<AssertingPartyMetadata.Builder<?>> assertingPartyMetadata) {
            assertingPartyMetadata.accept(this.assertingPartyMetadataBuilder);
            return this;
        }

        public RelyingPartyRegistration build() {
            if (this.singleLogoutServiceResponseLocation == null) {
                this.singleLogoutServiceResponseLocation = this.singleLogoutServiceLocation;
            }
            if (this.singleLogoutServiceBindings.isEmpty()) {
                this.singleLogoutServiceBindings.add(Saml2MessageBinding.POST);
            }
            AssertingPartyMetadata party = this.assertingPartyMetadataBuilder.build();
            return new RelyingPartyRegistration(this.registrationId, this.entityId, this.assertionConsumerServiceLocation, this.assertionConsumerServiceBinding, this.singleLogoutServiceLocation, this.singleLogoutServiceResponseLocation, this.singleLogoutServiceBindings, party, this.nameIdFormat, this.authnRequestsSigned, this.decryptionX509Credentials, this.signingX509Credentials);
        }
    }

    public static class AssertingPartyDetails
    implements AssertingPartyMetadata {
        private static final long serialVersionUID = 8728930758311995475L;
        private final String entityId;
        private final boolean wantAuthnRequestsSigned;
        private List<String> signingAlgorithms;
        private final Collection<Saml2X509Credential> verificationX509Credentials;
        private final Collection<Saml2X509Credential> encryptionX509Credentials;
        private final String singleSignOnServiceLocation;
        private final Saml2MessageBinding singleSignOnServiceBinding;
        private final String singleLogoutServiceLocation;
        private final String singleLogoutServiceResponseLocation;
        private final Saml2MessageBinding singleLogoutServiceBinding;

        AssertingPartyDetails(String entityId, boolean wantAuthnRequestsSigned, List<String> signingAlgorithms, Collection<Saml2X509Credential> verificationX509Credentials, Collection<Saml2X509Credential> encryptionX509Credentials, String singleSignOnServiceLocation, Saml2MessageBinding singleSignOnServiceBinding, String singleLogoutServiceLocation, String singleLogoutServiceResponseLocation, Saml2MessageBinding singleLogoutServiceBinding) {
            Assert.hasText((String)entityId, (String)"entityId cannot be null or empty");
            Assert.notEmpty(signingAlgorithms, (String)"signingAlgorithms cannot be empty");
            Assert.notNull(verificationX509Credentials, (String)"verificationX509Credentials cannot be null");
            for (Saml2X509Credential credential : verificationX509Credentials) {
                Assert.notNull((Object)credential, (String)"verificationX509Credentials cannot have null values");
                Assert.isTrue((boolean)credential.isVerificationCredential(), (String)"All verificationX509Credentials must have a usage of VERIFICATION set");
            }
            Assert.notNull(encryptionX509Credentials, (String)"encryptionX509Credentials cannot be null");
            for (Saml2X509Credential credential : encryptionX509Credentials) {
                Assert.notNull((Object)credential, (String)"encryptionX509Credentials cannot have null values");
                Assert.isTrue((boolean)credential.isEncryptionCredential(), (String)"All encryptionX509Credentials must have a usage of ENCRYPTION set");
            }
            Assert.notNull((Object)singleSignOnServiceLocation, (String)"singleSignOnServiceLocation cannot be null");
            Assert.notNull((Object)((Object)singleSignOnServiceBinding), (String)"singleSignOnServiceBinding cannot be null");
            this.entityId = entityId;
            this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
            this.signingAlgorithms = signingAlgorithms;
            this.verificationX509Credentials = verificationX509Credentials;
            this.encryptionX509Credentials = encryptionX509Credentials;
            this.singleSignOnServiceLocation = singleSignOnServiceLocation;
            this.singleSignOnServiceBinding = singleSignOnServiceBinding;
            this.singleLogoutServiceLocation = singleLogoutServiceLocation;
            this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
            this.singleLogoutServiceBinding = singleLogoutServiceBinding;
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public boolean getWantAuthnRequestsSigned() {
            return this.wantAuthnRequestsSigned;
        }

        @Override
        public List<String> getSigningAlgorithms() {
            return this.signingAlgorithms;
        }

        @Override
        public Collection<Saml2X509Credential> getVerificationX509Credentials() {
            return this.verificationX509Credentials;
        }

        @Override
        public Collection<Saml2X509Credential> getEncryptionX509Credentials() {
            return this.encryptionX509Credentials;
        }

        @Override
        public String getSingleSignOnServiceLocation() {
            return this.singleSignOnServiceLocation;
        }

        @Override
        public Saml2MessageBinding getSingleSignOnServiceBinding() {
            return this.singleSignOnServiceBinding;
        }

        @Override
        public String getSingleLogoutServiceLocation() {
            return this.singleLogoutServiceLocation;
        }

        @Override
        public String getSingleLogoutServiceResponseLocation() {
            return this.singleLogoutServiceResponseLocation;
        }

        @Override
        public Saml2MessageBinding getSingleLogoutServiceBinding() {
            return this.singleLogoutServiceBinding;
        }

        public Builder mutate() {
            return ((Builder)((Builder)((Builder)new Builder().entityId(this.entityId).wantAuthnRequestsSigned(this.wantAuthnRequestsSigned).signingAlgorithms(algorithms -> algorithms.addAll(this.signingAlgorithms))).verificationX509Credentials(c -> c.addAll(this.verificationX509Credentials))).encryptionX509Credentials(c -> c.addAll(this.encryptionX509Credentials))).singleSignOnServiceLocation(this.singleSignOnServiceLocation).singleSignOnServiceBinding(this.singleSignOnServiceBinding).singleLogoutServiceLocation(this.singleLogoutServiceLocation).singleLogoutServiceResponseLocation(this.singleLogoutServiceResponseLocation).singleLogoutServiceBinding(this.singleLogoutServiceBinding);
        }

        public static class Builder
        implements AssertingPartyMetadata.Builder<Builder> {
            private String entityId;
            private boolean wantAuthnRequestsSigned = true;
            private List<String> signingAlgorithms = new ArrayList<String>();
            private Collection<Saml2X509Credential> verificationX509Credentials = new LinkedHashSet<Saml2X509Credential>();
            private Collection<Saml2X509Credential> encryptionX509Credentials = new LinkedHashSet<Saml2X509Credential>();
            private String singleSignOnServiceLocation;
            private Saml2MessageBinding singleSignOnServiceBinding = Saml2MessageBinding.REDIRECT;
            private String singleLogoutServiceLocation;
            private String singleLogoutServiceResponseLocation;
            private Saml2MessageBinding singleLogoutServiceBinding = Saml2MessageBinding.REDIRECT;

            @Override
            public Builder entityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            @Override
            public Builder wantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
                this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
                return this;
            }

            @Override
            public Builder signingAlgorithms(Consumer<List<String>> signingMethodAlgorithmsConsumer) {
                signingMethodAlgorithmsConsumer.accept(this.signingAlgorithms);
                return this;
            }

            @Override
            public Builder verificationX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
                credentialsConsumer.accept(this.verificationX509Credentials);
                return this;
            }

            @Override
            public Builder encryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
                credentialsConsumer.accept(this.encryptionX509Credentials);
                return this;
            }

            @Override
            public Builder singleSignOnServiceLocation(String singleSignOnServiceLocation) {
                this.singleSignOnServiceLocation = singleSignOnServiceLocation;
                return this;
            }

            @Override
            public Builder singleSignOnServiceBinding(Saml2MessageBinding singleSignOnServiceBinding) {
                this.singleSignOnServiceBinding = singleSignOnServiceBinding;
                return this;
            }

            @Override
            public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
                this.singleLogoutServiceLocation = singleLogoutServiceLocation;
                return this;
            }

            @Override
            public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
                this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
                return this;
            }

            @Override
            public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
                this.singleLogoutServiceBinding = singleLogoutServiceBinding;
                return this;
            }

            @Override
            public AssertingPartyDetails build() {
                List<String> signingAlgorithms = this.signingAlgorithms.isEmpty() ? Collections.singletonList("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") : Collections.unmodifiableList(this.signingAlgorithms);
                return new AssertingPartyDetails(this.entityId, this.wantAuthnRequestsSigned, signingAlgorithms, this.verificationX509Credentials, this.encryptionX509Credentials, this.singleSignOnServiceLocation, this.singleSignOnServiceBinding, this.singleLogoutServiceLocation, this.singleLogoutServiceResponseLocation, this.singleLogoutServiceBinding);
            }
        }
    }
}

