/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class IpAddressMatcher
implements RequestMatcher {
    private static Pattern IPV4 = Pattern.compile("\\d{0,3}.\\d{0,3}.\\d{0,3}.\\d{0,3}(/\\d{0,3})?");
    private final InetAddress requiredAddress;
    private final int nMaskBits;

    public IpAddressMatcher(String ipAddress) {
        int nMaskBits;
        String requiredAddress;
        Assert.hasText((String)ipAddress, (String)"ipAddress cannot be empty");
        IpAddressMatcher.assertNotHostName(ipAddress);
        if (ipAddress.indexOf(47) > 0) {
            String[] parts = Objects.requireNonNull(StringUtils.split((String)ipAddress, (String)"/"));
            requiredAddress = parts[0];
            nMaskBits = Integer.parseInt(parts[1]);
        } else {
            requiredAddress = ipAddress;
            nMaskBits = -1;
        }
        this.requiredAddress = this.parseAddress(requiredAddress);
        this.nMaskBits = nMaskBits;
        Assert.isTrue((this.requiredAddress.getAddress().length * 8 >= this.nMaskBits ? 1 : 0) != 0, () -> String.format("IP address %s is too short for bitmask of length %d", requiredAddress, this.nMaskBits));
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return this.matches(request.getRemoteAddr());
    }

    public boolean matches(String ipAddress) {
        if (!StringUtils.hasText((String)ipAddress)) {
            return false;
        }
        IpAddressMatcher.assertNotHostName(ipAddress);
        InetAddress remoteAddress = this.parseAddress(ipAddress);
        if (!this.requiredAddress.getClass().equals(remoteAddress.getClass())) {
            return false;
        }
        if (this.nMaskBits < 0) {
            return remoteAddress.equals(this.requiredAddress);
        }
        byte[] remAddr = remoteAddress.getAddress();
        byte[] reqAddr = this.requiredAddress.getAddress();
        int nMaskFullBytes = this.nMaskBits / 8;
        for (int i = 0; i < nMaskFullBytes; ++i) {
            if (remAddr[i] == reqAddr[i]) continue;
            return false;
        }
        byte finalByte = (byte)(65280 >> (this.nMaskBits & 7));
        if (finalByte != 0) {
            return (remAddr[nMaskFullBytes] & finalByte) == (reqAddr[nMaskFullBytes] & finalByte);
        }
        return true;
    }

    private static void assertNotHostName(String ipAddress) {
        Assert.isTrue((boolean)IpAddressMatcher.isIpAddress(ipAddress), () -> String.format("ipAddress %s doesn't look like an IP Address. Is it a host name?", ipAddress));
    }

    private static boolean isIpAddress(String ipAddress) {
        return IPV4.matcher(ipAddress).matches() || ipAddress.charAt(0) == '[' || ipAddress.charAt(0) == ':' || Character.digit(ipAddress.charAt(0), 16) != -1 && ipAddress.indexOf(58) > 0;
    }

    private InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Failed to parse address '" + address + "'", ex);
        }
    }
}

