/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.access.channel.ChannelEntryPoint;
import org.springframework.util.Assert;

@Deprecated
public abstract class AbstractRetryEntryPoint
implements ChannelEntryPoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private final String scheme;
    private final int standardPort;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public AbstractRetryEntryPoint(String scheme, int standardPort) {
        this.scheme = scheme;
        this.standardPort = standardPort;
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String queryString = request.getQueryString();
        String redirectUrl = request.getRequestURI() + (String)(queryString != null ? "?" + queryString : "");
        Integer currentPort = this.portResolver.getServerPort((ServletRequest)request);
        Integer redirectPort = this.getMappedPort(currentPort);
        if (redirectPort != null) {
            boolean includePort = redirectPort != this.standardPort;
            Object port = includePort ? ":" + redirectPort : "";
            redirectUrl = this.scheme + request.getServerName() + (String)port + redirectUrl;
        }
        this.logger.debug((Object)LogMessage.format((String)"Redirecting to: %s", (Object)redirectUrl));
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    protected abstract Integer getMappedPort(Integer var1);

    protected final PortMapper getPortMapper() {
        return this.portMapper;
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, (String)"portMapper cannot be null");
        this.portMapper = portMapper;
    }

    @Deprecated(forRemoval=true)
    public void setPortResolver(PortResolver portResolver) {
        Assert.notNull((Object)portResolver, (String)"portResolver cannot be null");
        this.portResolver = portResolver;
    }

    @Deprecated(forRemoval=true)
    protected final PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        Assert.notNull((Object)redirectStrategy, (String)"redirectStrategy cannot be null");
        this.redirectStrategy = redirectStrategy;
    }

    protected final RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }
}

