/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;

public class DelegatingAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DelegatingAuthenticationEntryPoint.class);
    private final List<RequestMatcherEntry<AuthenticationEntryPoint>> entryPoints;
    private AuthenticationEntryPoint defaultEntryPoint;

    public DelegatingAuthenticationEntryPoint(AuthenticationEntryPoint defaultEntryPoint, RequestMatcherEntry<AuthenticationEntryPoint> ... entryPoints) {
        Assert.notEmpty((Object[])entryPoints, (String)"entryPoints cannot be empty");
        Assert.notNull((Object)defaultEntryPoint, (String)"defaultEntryPoint cannot be null");
        this.entryPoints = Arrays.asList(entryPoints);
        this.defaultEntryPoint = defaultEntryPoint;
    }

    public DelegatingAuthenticationEntryPoint(AuthenticationEntryPoint defaultEntryPoint, List<RequestMatcherEntry<AuthenticationEntryPoint>> entryPoints) {
        Assert.notEmpty(entryPoints, (String)"entryPoints cannot be empty");
        Assert.notNull((Object)defaultEntryPoint, (String)"defaultEntryPoint cannot be null");
        this.entryPoints = entryPoints;
        this.defaultEntryPoint = defaultEntryPoint;
    }

    @Deprecated(forRemoval=true)
    public DelegatingAuthenticationEntryPoint(LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints) {
        this.entryPoints = entryPoints.entrySet().stream().map(e -> new RequestMatcherEntry<AuthenticationEntryPoint>((RequestMatcher)e.getKey(), (AuthenticationEntryPoint)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        for (RequestMatcherEntry<AuthenticationEntryPoint> entry : this.entryPoints) {
            RequestMatcher requestMatcher = entry.getRequestMatcher();
            logger.debug((Object)LogMessage.format((String)"Trying to match using %s", (Object)requestMatcher));
            if (!requestMatcher.matches(request)) continue;
            AuthenticationEntryPoint entryPoint = entry.getEntry();
            logger.debug((Object)LogMessage.format((String)"Match found! Executing %s", (Object)entryPoint));
            entryPoint.commence(request, response, authException);
            return;
        }
        logger.debug((Object)LogMessage.format((String)"No match found. Using default entry point %s", (Object)this.defaultEntryPoint));
        this.defaultEntryPoint.commence(request, response, authException);
    }

    @Deprecated(forRemoval=true)
    public void setDefaultEntryPoint(AuthenticationEntryPoint defaultEntryPoint) {
        this.defaultEntryPoint = defaultEntryPoint;
    }

    public void afterPropertiesSet() {
        Assert.notEmpty(this.entryPoints, (String)"entryPoints must be specified");
        Assert.notNull((Object)this.defaultEntryPoint, (String)"defaultEntryPoint must be specified");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable AuthenticationEntryPoint defaultEntryPoint;
        private List<RequestMatcherEntry<AuthenticationEntryPoint>> entryPoints = new ArrayList<RequestMatcherEntry<AuthenticationEntryPoint>>();

        public Builder defaultEntryPoint(@Nullable AuthenticationEntryPoint defaultEntryPoint) {
            this.defaultEntryPoint = defaultEntryPoint;
            return this;
        }

        public Builder addEntryPointFor(AuthenticationEntryPoint entryPoint, RequestMatcher requestMatcher) {
            Assert.notNull((Object)entryPoint, (String)"entryPoint cannot be null");
            Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
            this.entryPoints.add(new RequestMatcherEntry<AuthenticationEntryPoint>(requestMatcher, entryPoint));
            return this;
        }

        public AuthenticationEntryPoint build() {
            AuthenticationEntryPoint defaultEntryPoint = this.defaultEntryPoint;
            if (defaultEntryPoint == null) {
                Assert.state((!this.entryPoints.isEmpty() ? 1 : 0) != 0, (String)"entryPoints cannot be empty if defaultEntryPoint is null");
                AuthenticationEntryPoint firstAuthenticationEntryPoint = this.entryPoints.get(0).getEntry();
                if (this.entryPoints.size() == 1) {
                    return firstAuthenticationEntryPoint;
                }
                defaultEntryPoint = firstAuthenticationEntryPoint;
            } else if (this.entryPoints.isEmpty()) {
                return defaultEntryPoint;
            }
            return new DelegatingAuthenticationEntryPoint(defaultEntryPoint, this.entryPoints);
        }

        private Builder() {
        }
    }
}

