/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.DBObject;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.lang.Nullable;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;

public class MongoIndexedSessionRepository
implements FindByIndexNameSessionRepository<MongoSession>,
ApplicationEventPublisherAware,
InitializingBean {
    @Deprecated
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private static final Log logger = LogFactory.getLog(MongoIndexedSessionRepository.class);
    private final MongoOperations mongoOperations;
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(this.defaultMaxInactiveInterval);
    private ApplicationEventPublisher eventPublisher;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    public MongoIndexedSessionRepository(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public MongoSession createSession() {
        MongoSession session = new MongoSession(this.sessionIdGenerator, this.defaultMaxInactiveInterval.toSeconds());
        this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
        return session;
    }

    public void save(MongoSession session) {
        DBObject dbObject = MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session);
        Assert.notNull((Object)dbObject, (String)"dbObject must not be null");
        this.mongoOperations.save((Object)dbObject, this.collectionName);
    }

    @Nullable
    public MongoSession findById(String id) {
        Document sessionWrapper = this.findSession(id);
        if (sessionWrapper == null) {
            return null;
        }
        MongoSession session = MongoSessionUtils.convertToSession(this.mongoSessionConverter, sessionWrapper);
        if (session != null) {
            if (session.isExpired()) {
                this.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)session));
                this.deleteById(id);
                return null;
            }
            session.setSessionIdGenerator(this.sessionIdGenerator);
        }
        return session;
    }

    public Map<String, MongoSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return Optional.ofNullable(this.mongoSessionConverter.getQueryForIndex(indexName, indexValue)).map(query -> this.mongoOperations.find(query, Document.class, this.collectionName)).orElse(Collections.emptyList()).stream().map(dbSession -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, dbSession)).peek(session -> session.setSessionIdGenerator(this.sessionIdGenerator)).collect(Collectors.toMap(MongoSession::getId, mapSession -> mapSession));
    }

    public void deleteById(String id) {
        Optional.ofNullable(this.findSession(id)).ifPresent(document -> {
            MongoSession session = MongoSessionUtils.convertToSession(this.mongoSessionConverter, document);
            if (session != null) {
                this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
            }
            this.mongoOperations.remove(document, this.collectionName);
        });
    }

    public void afterPropertiesSet() {
        IndexOperations indexOperations = this.mongoOperations.indexOps(this.collectionName);
        this.mongoSessionConverter.ensureIndexes(indexOperations);
    }

    @Nullable
    private Document findSession(String id) {
        return (Document)this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error((Object)("Error publishing " + event + "."), ex);
        }
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Deprecated(since="3.0.0")
    public void setMaxInactiveIntervalInSeconds(Integer defaultMaxInactiveInterval) {
        this.setDefaultMaxInactiveInterval(Duration.ofSeconds(defaultMaxInactiveInterval.intValue()));
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        Assert.notNull((Object)sessionIdGenerator, (String)"sessionIdGenerator cannot be null");
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

